/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.util.ReflectionUtils;

public class SendForwardFilter
extends ZuulFilter {
    protected static final String SEND_FORWARD_FILTER_RAN = "sendForwardFilter.ran";

    public String filterType() {
        return "route";
    }

    public int filterOrder() {
        return 500;
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        return ctx.containsKey((Object)"forward.to") && !ctx.getBoolean(SEND_FORWARD_FILTER_RAN, false);
    }

    public Object run() {
        try {
            RequestContext ctx = RequestContext.getCurrentContext();
            String path = (String)ctx.get((Object)"forward.to");
            RequestDispatcher dispatcher = ctx.getRequest().getRequestDispatcher(path);
            if (dispatcher != null) {
                ctx.set(SEND_FORWARD_FILTER_RAN, (Object)true);
                if (!ctx.getResponse().isCommitted()) {
                    dispatcher.forward((ServletRequest)ctx.getRequest(), (ServletResponse)ctx.getResponse());
                    ctx.getResponse().flushBuffer();
                }
            }
        }
        catch (Exception ex) {
            ReflectionUtils.rethrowRuntimeException((Throwable)ex);
        }
        return null;
    }
}

