/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters;

import com.netflix.zuul.context.RequestContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.actuate.trace.http.HttpExchangeTracer;
import org.springframework.boot.actuate.trace.http.HttpTrace;
import org.springframework.boot.actuate.trace.http.HttpTraceRepository;
import org.springframework.boot.actuate.trace.http.Include;
import org.springframework.boot.actuate.trace.http.TraceableRequest;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.filters.ServletTraceableRequest;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.util.MultiValueMap;

public class TraceProxyRequestHelper
extends ProxyRequestHelper {
    private HttpTraceRepository traces;
    private final HttpExchangeTracer tracer = new HttpExchangeTracer(Include.defaultIncludes());

    @Deprecated
    public TraceProxyRequestHelper() {
    }

    public TraceProxyRequestHelper(ZuulProperties zuulProperties) {
        super(zuulProperties);
    }

    public void setTraces(HttpTraceRepository traces) {
        this.traces = traces;
    }

    @Override
    public Map<String, Object> debug(String verb, String uri, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity) throws IOException {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        if (this.traces != null) {
            RequestContext context = RequestContext.getCurrentContext();
            info.put("method", verb);
            info.put("path", uri);
            info.put("query", this.getQueryString(params));
            info.put("remote", true);
            info.put("proxy", context.get((Object)"proxy"));
            LinkedHashMap<String, LinkedHashMap<String, Object>> trace = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
            LinkedHashMap<String, Object> input = new LinkedHashMap<String, Object>();
            trace.put("request", input);
            info.put("headers", trace);
            this.debugHeaders(headers, input);
            HttpServletRequest request = context.getRequest();
            if (this.shouldDebugBody(context) && requestEntity != null) {
                this.debugRequestEntity(info, (InputStream)request.getInputStream());
            }
            HttpTrace httpTrace = this.tracer.receivedRequest((TraceableRequest)new ServletTraceableRequest(request));
            this.traces.add(httpTrace);
            return info;
        }
        return info;
    }

    void debugHeaders(MultiValueMap<String, String> headers, Map<String, Object> map) {
        for (Map.Entry entry : headers.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            Object value = collection;
            if (collection.size() < 2) {
                value = collection.isEmpty() ? "" : collection.iterator().next();
            }
            map.put((String)entry.getKey(), value);
        }
    }

    @Override
    public void appendDebug(Map<String, Object> info, int status, MultiValueMap<String, String> headers) {
        if (this.traces != null) {
            Map trace = (Map)info.get("headers");
            LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
            trace.put("response", output);
            this.debugHeaders(headers, output);
            output.put("status", "" + status);
        }
    }

    private void debugRequestEntity(Map<String, Object> info, InputStream inputStream) throws IOException {
        if (RequestContext.getCurrentContext().isChunkedRequestBody()) {
            info.put("body", "<chunked>");
            return;
        }
        char[] buffer = new char[4096];
        int count = new InputStreamReader(inputStream, Charset.forName("UTF-8")).read(buffer, 0, buffer.length);
        if (count > 0) {
            String entity = new String(buffer).substring(0, count);
            info.put("body", entity.length() < 4096 ? entity : entity + "<truncated>");
        }
    }
}

