/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.schema.registry.avro;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.schema.registry.avro.DefaultSubjectNamingStrategy;
import org.springframework.cloud.schema.registry.avro.SubjectNamingStrategy;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="spring.cloud.schema.avro")
public class AvroMessageConverterProperties {
    private boolean dynamicSchemaGenerationEnabled;
    private Resource readerSchema;
    private Resource[] schemaLocations;
    private Resource[] schemaImports;
    private String prefix = "vnd";
    private String subjectNamePrefix;
    private Class<? extends SubjectNamingStrategy> subjectNamingStrategy = DefaultSubjectNamingStrategy.class;

    public Resource getReaderSchema() {
        return this.readerSchema;
    }

    public void setReaderSchema(Resource readerSchema) {
        Assert.notNull((Object)readerSchema, (String)"cannot be null");
        this.readerSchema = readerSchema;
    }

    public Resource[] getSchemaLocations() {
        return this.schemaLocations;
    }

    public void setSchemaLocations(Resource[] schemaLocations) {
        Assert.notEmpty((Object[])schemaLocations, (String)"cannot be null");
        this.schemaLocations = schemaLocations;
    }

    public boolean isDynamicSchemaGenerationEnabled() {
        return this.dynamicSchemaGenerationEnabled;
    }

    public void setDynamicSchemaGenerationEnabled(boolean dynamicSchemaGenerationEnabled) {
        this.dynamicSchemaGenerationEnabled = dynamicSchemaGenerationEnabled;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Class<?> getSubjectNamingStrategy() {
        return this.subjectNamingStrategy;
    }

    public void setSubjectNamingStrategy(Class<? extends SubjectNamingStrategy> subjectNamingStrategy) {
        Assert.notNull(subjectNamingStrategy, (String)"cannot be null");
        this.subjectNamingStrategy = subjectNamingStrategy;
    }

    public Resource[] getSchemaImports() {
        return this.schemaImports;
    }

    public void setSchemaImports(Resource[] schemaImports) {
        this.schemaImports = schemaImports;
    }

    public String getSubjectNamePrefix() {
        return this.subjectNamePrefix;
    }

    public void setSubjectNamePrefix(String subjectNamePrefix) {
        this.subjectNamePrefix = subjectNamePrefix;
    }
}

