/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.support.yaml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.cloud.skipper.support.yaml.YamlConversionStatus;
import org.springframework.cloud.skipper.support.yaml.YamlConverter;
import org.springframework.cloud.skipper.support.yaml.YamlPath;
import org.springframework.cloud.skipper.support.yaml.YamlPathSegment;

class YamlBuilder {
    private final YamlConverter.Mode mode;
    private final ArrayList<String> keyspaceList;
    private final YamlConversionStatus status;
    private final YamlPath path;
    private final List<String> scalars = new ArrayList<String>();
    private final TreeMap<Integer, YamlBuilder> listItems = new TreeMap();
    private final TreeMap<String, YamlBuilder> mapEntries = new TreeMap();

    YamlBuilder(YamlConverter.Mode mode, ArrayList<String> keyspaceList, YamlConversionStatus status, YamlPath path) {
        this.mode = mode;
        this.keyspaceList = keyspaceList;
        this.status = status;
        this.path = path;
    }

    public void addProperty(YamlPath path, String value) {
        if (path.isEmpty()) {
            this.scalars.add(value);
        } else {
            YamlPathSegment segment = path.getSegment(0);
            YamlBuilder subBuilder = segment instanceof YamlPathSegment.AtIndex ? this.getSubBuilder(this.listItems, segment, segment.toIndex()) : this.getSubBuilder(this.mapEntries, segment, segment.toPropString());
            subBuilder.addProperty(path.dropFirst(1), value);
        }
    }

    public Object build() {
        String propString = this.path.toPropString();
        boolean force = this.keyspaceList.stream().anyMatch(s -> {
            Matcher m = Pattern.compile(s).matcher(propString);
            return m.lookingAt() && !m.matches();
        });
        Flatten flatten = null;
        if (!this.scalars.isEmpty()) {
            if (this.listItems.isEmpty() && this.mapEntries.isEmpty()) {
                if (this.scalars.size() > 1) {
                    this.status.addWarning("Multiple values " + this.scalars + " assigned to '" + this.path.toPropString() + "'. Values will be merged into a yaml sequence node.");
                    return this.scalars;
                }
                return this.scalars.get(0);
            }
            if (this.mode == YamlConverter.Mode.FLATTEN) {
                flatten = new Flatten();
                flatten.list = this.scalars;
            } else {
                if (!this.mapEntries.isEmpty()) {
                    this.status.addError("Direct assignment '" + this.path.toPropString() + "=" + this.scalars.get(0) + "' can not be combined with sub-property assignment '" + this.path.toPropString() + "." + this.mapEntries.keySet().iterator().next() + "...'. Direct assignment will be dropped!");
                } else {
                    this.status.addError("Direct assignment '" + this.path.toPropString() + "=" + this.scalars.get(0) + "' can not be combined with sequence assignment '" + this.path.toPropString() + "[" + this.listItems.keySet().iterator().next() + "]...' Direct assignments will be dropped!");
                }
                this.scalars.clear();
            }
        }
        if (!this.listItems.isEmpty() && !this.mapEntries.isEmpty()) {
            this.status.addWarning("'" + this.path.toPropString() + "' has some entries that look like list items and others that look like map entries. All these entries will be treated as map entries");
            for (Map.Entry<Integer, YamlBuilder> listItem : this.listItems.entrySet()) {
                this.mapEntries.put(listItem.getKey().toString(), listItem.getValue());
            }
            this.listItems.clear();
        }
        if (!this.listItems.isEmpty()) {
            return this.listItems.values().stream().map(childBuilder -> childBuilder.build()).collect(Collectors.toList());
        }
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        if (force) {
            flatten = new Flatten();
        }
        for (Map.Entry<String, YamlBuilder> entry : this.mapEntries.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue().build();
            if (this.mode == YamlConverter.Mode.FLATTEN && value instanceof Flatten) {
                Flatten f = (Flatten)value;
                if (f.list != null && f.list.size() == 1) {
                    map.put(key, f.list.get(0));
                } else if (f.list != null) {
                    map.put(key, f.list);
                }
                for (Map.Entry<String, Object> e : f.map.entrySet()) {
                    if (e.getValue() == null) continue;
                    map.put(key + "." + e.getKey(), e.getValue());
                }
                continue;
            }
            map.put(key, value);
        }
        if (flatten != null) {
            flatten.map = map;
            return flatten;
        }
        return map;
    }

    private <T> YamlBuilder getSubBuilder(TreeMap<T, YamlBuilder> subBuilders, YamlPathSegment segment, T key) {
        YamlBuilder existing = subBuilders.get(key);
        if (existing == null) {
            existing = new YamlBuilder(this.mode, this.keyspaceList, this.status, this.path.append(segment));
            subBuilders.put(key, existing);
        }
        return existing;
    }

    private static class Flatten {
        List<String> list;
        Map<String, Object> map;

        private Flatten() {
        }
    }
}

