/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.brave;

import brave.Tracing;
import brave.handler.SpanHandler;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.SleuthBaggageProperties;
import org.springframework.cloud.sleuth.autoconfig.brave.SleuthPropagationProperties;
import org.springframework.cloud.sleuth.brave.bridge.BraveBaggageManager;
import org.springframework.cloud.sleuth.brave.bridge.BraveCurrentTraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BravePropagator;
import org.springframework.cloud.sleuth.brave.bridge.BraveSpanCustomizer;
import org.springframework.cloud.sleuth.brave.bridge.BraveTracer;
import org.springframework.cloud.sleuth.brave.bridge.CompositePropagationFactorySupplier;
import org.springframework.cloud.sleuth.brave.bridge.CompositeSpanHandler;
import org.springframework.cloud.sleuth.brave.propagation.PropagationFactorySupplier;
import org.springframework.cloud.sleuth.exporter.SpanFilter;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SleuthPropagationProperties.class})
class BraveBridgeConfiguration {
    BraveBridgeConfiguration() {
    }

    @Bean
    Tracer braveTracer(brave.Tracer tracer) {
        return new BraveTracer(tracer, new BraveBaggageManager());
    }

    @Bean
    CurrentTraceContext braveCurrentTraceContext(brave.propagation.CurrentTraceContext currentTraceContext) {
        return new BraveCurrentTraceContext(currentTraceContext);
    }

    @Bean
    SpanCustomizer braveSpanCustomizer(brave.SpanCustomizer spanCustomizer) {
        return new BraveSpanCustomizer(spanCustomizer);
    }

    @Bean
    Propagator bravePropagator(Tracing tracing) {
        return new BravePropagator(tracing);
    }

    @Bean
    @ConditionalOnMissingBean
    PropagationFactorySupplier compositePropagationFactorySupplier(BeanFactory beanFactory, SleuthBaggageProperties baggageProperties, SleuthPropagationProperties properties) {
        return new CompositePropagationFactorySupplier(beanFactory, baggageProperties.getLocalFields(), properties.getType());
    }

    @Bean(name={"traceCompositeSpanHandler"})
    SpanHandler compositeSpanHandler(@Nullable List<SpanFilter> exporters) {
        return new CompositeSpanHandler(exporters);
    }
}

