/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.reactor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.autoconfig.instrument.reactor.HookRegisteringBeanDefinitionRegistryPostProcessor;
import org.springframework.cloud.sleuth.autoconfig.instrument.reactor.TraceReactorAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import reactor.core.publisher.Hooks;
import reactor.core.scheduler.Schedulers;

public final class TraceReactorAutoConfigurationAccessorConfiguration {
    private static final Log log = LogFactory.getLog(TraceReactorAutoConfigurationAccessorConfiguration.class);

    private TraceReactorAutoConfigurationAccessorConfiguration() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static void close() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Cleaning up hooks");
        }
        Hooks.resetOnEachOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY);
        Hooks.resetOnLastOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY);
        Schedulers.removeExecutorServiceDecorator((String)"sleuth");
    }

    public static void setup(ConfigurableApplicationContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Setting up hooks");
        }
        HookRegisteringBeanDefinitionRegistryPostProcessor.setupHooks(context);
    }
}

