/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.r2dbc;

import io.r2dbc.spi.ConnectionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.autoconfig.instrument.r2dbc.TraceProxyConnectionFactoryWrapper;

public class TraceConnectionFactoryBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;

    public TraceConnectionFactoryBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ConnectionFactory) {
            return this.wrapConnectionFactory((ConnectionFactory)bean);
        }
        return bean;
    }

    ConnectionFactory wrapConnectionFactory(ConnectionFactory bean) {
        TraceProxyConnectionFactoryWrapper proxyPostProcessor = new TraceProxyConnectionFactoryWrapper(this.beanFactory);
        return proxyPostProcessor.apply(bean);
    }
}

