/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.async;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.autoconfig.instrument.async.SleuthAsyncProperties;
import org.springframework.cloud.sleuth.instrument.async.ExecutorInstrumentor;

public class ExecutorBeanPostProcessor
implements BeanPostProcessor {
    private static final Log log = LogFactory.getLog(ExecutorBeanPostProcessor.class);
    private final BeanFactory beanFactory;
    private SleuthAsyncProperties sleuthAsyncProperties;

    public ExecutorBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!ExecutorInstrumentor.isApplicableForInstrumentation((Object)bean)) {
            return bean;
        }
        return new ExecutorInstrumentor(() -> this.sleuthAsyncProperties().getIgnoredBeans(), this.beanFactory).instrument(bean, beanName);
    }

    private SleuthAsyncProperties sleuthAsyncProperties() {
        if (this.sleuthAsyncProperties == null) {
            this.sleuthAsyncProperties = (SleuthAsyncProperties)this.beanFactory.getBean(SleuthAsyncProperties.class);
        }
        return this.sleuthAsyncProperties;
    }
}

