/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.messaging;

import brave.kafka.clients.KafkaTracing;
import org.apache.kafka.clients.consumer.Consumer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.kafka.core.ConsumerPostProcessor;
import org.springframework.util.ClassUtils;

class TraceConsumerPostProcessor<K, V>
implements ConsumerPostProcessor<K, V> {
    private final BeanFactory beanFactory;
    private KafkaTracing kafkaTracing;
    private static final Class tracingConsumer = ClassUtils.resolveClassName((String)"brave.kafka.clients.TracingConsumer", null);

    TraceConsumerPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    private KafkaTracing kafkaTracing() {
        if (this.kafkaTracing == null) {
            this.kafkaTracing = (KafkaTracing)this.beanFactory.getBean(KafkaTracing.class);
        }
        return this.kafkaTracing;
    }

    public Consumer<K, V> apply(Consumer<K, V> kvConsumer) {
        if (tracingConsumer.isAssignableFrom(ClassUtils.getUserClass(kvConsumer.getClass()))) {
            return kvConsumer;
        }
        return this.wrapInTracing(kvConsumer);
    }

    Consumer<K, V> wrapInTracing(Consumer<K, V> kvConsumer) {
        return this.kafkaTracing().consumer(kvConsumer);
    }
}

