/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.instrument.messaging.SpanAndScope;

class ThreadLocalSpan {
    private static final Log log = LogFactory.getLog(ThreadLocalSpan.class);
    final ThreadLocal<SpanAndScope> threadLocalSpan = new ThreadLocal();
    final LinkedBlockingDeque<SpanAndScope> spans = new LinkedBlockingDeque();

    ThreadLocalSpan() {
    }

    void set(SpanAndScope spanAndScope) {
        SpanAndScope scope = this.threadLocalSpan.get();
        if (scope != null) {
            this.spans.addFirst(scope);
        }
        this.threadLocalSpan.set(spanAndScope);
    }

    SpanAndScope get() {
        return this.threadLocalSpan.get();
    }

    void remove() {
        block4: {
            this.threadLocalSpan.remove();
            if (this.spans.isEmpty()) {
                return;
            }
            try {
                SpanAndScope span = this.spans.removeFirst();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Took span [" + span + "] from thread local"));
                }
                this.threadLocalSpan.set(span);
            }
            catch (NoSuchElementException ex) {
                if (!log.isTraceEnabled()) break block4;
                log.trace((Object)"Failed to remove a span from the queue", (Throwable)ex);
            }
        }
    }
}

