/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.Nullable;

public final class LazyBean<T> {
    private static final Log log = LogFactory.getLog(LazyBean.class);
    final ConfigurableApplicationContext springContext;
    final Class<T> requiredType;
    T value;

    public static <T> LazyBean<T> create(ConfigurableApplicationContext springContext, Class<T> requiredType) {
        return new LazyBean<T>(springContext, requiredType);
    }

    LazyBean(ConfigurableApplicationContext springContext, Class<T> requiredType) {
        this.springContext = springContext;
        this.requiredType = requiredType;
    }

    @Nullable
    public T get() {
        block3: {
            if (this.value != null) {
                return this.value;
            }
            try {
                this.value = this.springContext.getBean(this.requiredType);
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Spring context [" + this.springContext + "] error getting [" + this.requiredType + "]."), (Throwable)ex);
            }
        }
        return this.value;
    }
}

