/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.cloud.sleuth.instrument.reactor.TraceContextPropagator;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Scannable;
import reactor.core.publisher.ConnectableFlux;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;

final class SleuthConnectableLift<I, O>
extends ConnectableFlux<O>
implements Scannable,
TraceContextPropagator {
    final ConnectableFlux<I> source;
    final BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter;

    SleuthConnectableLift(ConnectableFlux<I> p, BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter) {
        this.source = Objects.requireNonNull(p, "source");
        this.lifter = lifter;
    }

    public int getPrefetch() {
        return this.source.getPrefetch();
    }

    public void connect(Consumer<? super Disposable> cancelSupport) {
        this.source.connect(cancelSupport);
    }

    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return this.source.getPrefetch();
        }
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }

    public void subscribe(CoreSubscriber<? super O> actual) {
        CoreSubscriber<? super O> input = actual;
        try {
            input = Objects.requireNonNull(this.lifter.apply((Publisher)this.source, (CoreSubscriber<O>)actual), "Lifted subscriber MUST NOT be null");
            this.source.subscribe(input);
        }
        catch (Throwable e) {
            Operators.reportThrowInSubscribe(input, (Throwable)e);
            return;
        }
    }
}

