/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceScheduledThreadPoolExecutor;
import org.springframework.cloud.sleuth.instrument.async.TraceCallable;
import org.springframework.cloud.sleuth.instrument.async.TraceRunnable;
import org.springframework.cloud.sleuth.instrument.async.TraceableExecutorService;
import org.springframework.cloud.sleuth.instrument.async.TraceableScheduledExecutorService;
import org.springframework.cloud.sleuth.internal.ContextUtil;
import org.springframework.cloud.sleuth.internal.DefaultSpanNamer;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.CustomizableThreadCreator;
import org.springframework.util.ErrorHandler;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.concurrent.ListenableFuture;

class LazyTraceThreadPoolTaskScheduler
extends ThreadPoolTaskScheduler {
    private static final Log log = LogFactory.getLog(LazyTraceThreadPoolTaskScheduler.class);
    private final BeanFactory beanFactory;
    private final ThreadPoolTaskScheduler delegate;
    private final String beanName;
    private final Method initializeExecutor;
    private final Method createExecutor;
    private final Method cancelRemainingTask;
    private final Method nextThreadName;
    private final Method getDefaultThreadNamePrefix;
    private Tracer tracing;
    private SpanNamer spanNamer;

    LazyTraceThreadPoolTaskScheduler(BeanFactory beanFactory, ThreadPoolTaskScheduler delegate, String beanName) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
        this.beanName = beanName;
        this.initializeExecutor = ReflectionUtils.findMethod(ThreadPoolTaskScheduler.class, (String)"initializeExecutor", null);
        this.makeAccessibleIfNotNull(this.initializeExecutor);
        this.createExecutor = ReflectionUtils.findMethod(ThreadPoolTaskScheduler.class, (String)"createExecutor", null);
        this.makeAccessibleIfNotNull(this.createExecutor);
        this.cancelRemainingTask = ReflectionUtils.findMethod(ThreadPoolTaskScheduler.class, (String)"cancelRemainingTask", null);
        this.makeAccessibleIfNotNull(this.cancelRemainingTask);
        this.nextThreadName = ReflectionUtils.findMethod(ThreadPoolTaskScheduler.class, (String)"nextThreadName", null);
        this.makeAccessibleIfNotNull(this.nextThreadName);
        this.getDefaultThreadNamePrefix = ReflectionUtils.findMethod(CustomizableThreadCreator.class, (String)"getDefaultThreadNamePrefix", null);
        this.makeAccessibleIfNotNull(this.getDefaultThreadNamePrefix);
    }

    private void makeAccessibleIfNotNull(Method method) {
        if (method != null) {
            ReflectionUtils.makeAccessible((Method)method);
        }
    }

    private Runnable traceRunnableWhenContextReady(Runnable delegate) {
        if (ContextUtil.isContextUnusable(this.beanFactory)) {
            return delegate;
        }
        if (delegate instanceof TraceRunnable) {
            return delegate;
        }
        return new TraceRunnable(this.tracing(), this.spanNamer(), delegate, this.beanName);
    }

    private <V> Callable<V> traceCallableWhenContextReady(Callable<V> delegate) {
        if (ContextUtil.isContextUnusable(this.beanFactory)) {
            return delegate;
        }
        if (delegate instanceof TraceCallable) {
            return delegate;
        }
        return new TraceCallable<V>(this.tracing(), this.spanNamer(), delegate, this.beanName);
    }

    public void setPoolSize(int poolSize) {
        this.delegate.setPoolSize(poolSize);
    }

    public void setRemoveOnCancelPolicy(boolean removeOnCancelPolicy) {
        this.delegate.setRemoveOnCancelPolicy(removeOnCancelPolicy);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.delegate.setErrorHandler(errorHandler);
    }

    public ExecutorService initializeExecutor(ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        ExecutorService executorService = (ExecutorService)ReflectionUtils.invokeMethod((Method)this.initializeExecutor, (Object)this.delegate, (Object[])new Object[]{this.traceThreadFactory(threadFactory), this.traceRejectedExecutionHandler(rejectedExecutionHandler)});
        if (executorService instanceof TraceableScheduledExecutorService) {
            return executorService;
        }
        return new TraceableExecutorService(this.beanFactory, executorService, this.beanName);
    }

    private RejectedExecutionHandler traceRejectedExecutionHandler(final RejectedExecutionHandler rejectedExecutionHandler) {
        return new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                rejectedExecutionHandler.rejectedExecution(LazyTraceThreadPoolTaskScheduler.this.traceRunnableWhenContextReady(r), executor);
            }
        };
    }

    private ThreadFactory traceThreadFactory(ThreadFactory threadFactory) {
        return r -> threadFactory.newThread(this.traceRunnableWhenContextReady(r));
    }

    public ScheduledExecutorService createExecutor(int poolSize, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        ScheduledExecutorService executorService = (ScheduledExecutorService)ReflectionUtils.invokeMethod((Method)this.createExecutor, (Object)this.delegate, (Object[])new Object[]{poolSize, this.traceThreadFactory(threadFactory), this.traceRejectedExecutionHandler(rejectedExecutionHandler)});
        if (executorService instanceof TraceableScheduledExecutorService) {
            return executorService;
        }
        return new TraceableScheduledExecutorService(this.beanFactory, executorService, this.beanName);
    }

    public ScheduledExecutorService getScheduledExecutor() throws IllegalStateException {
        ScheduledExecutorService executor = this.delegate.getScheduledExecutor();
        return executor instanceof TraceableScheduledExecutorService ? executor : new TraceableScheduledExecutorService(this.beanFactory, executor, this.beanName);
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() throws IllegalStateException {
        ScheduledThreadPoolExecutor executor = this.delegate.getScheduledThreadPoolExecutor();
        if (executor instanceof LazyTraceScheduledThreadPoolExecutor) {
            return executor;
        }
        return new LazyTraceScheduledThreadPoolExecutor(executor.getCorePoolSize(), executor.getThreadFactory(), executor.getRejectedExecutionHandler(), this.beanFactory, executor, this.beanName);
    }

    public int getPoolSize() {
        return this.delegate.getPoolSize();
    }

    public boolean isRemoveOnCancelPolicy() {
        return this.delegate.isRemoveOnCancelPolicy();
    }

    public int getActiveCount() {
        return this.delegate.getActiveCount();
    }

    public void execute(Runnable task) {
        this.delegate.execute(this.traceRunnableWhenContextReady(task));
    }

    public void execute(Runnable task, long startTimeout) {
        this.delegate.execute(this.traceRunnableWhenContextReady(task), startTimeout);
    }

    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.traceRunnableWhenContextReady(task));
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.traceCallableWhenContextReady(task));
    }

    public ListenableFuture<?> submitListenable(Runnable task) {
        return this.delegate.submitListenable(this.traceRunnableWhenContextReady(task));
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        return this.delegate.submitListenable(this.traceCallableWhenContextReady(task));
    }

    public void cancelRemainingTask(Runnable task) {
        ReflectionUtils.invokeMethod((Method)this.cancelRemainingTask, (Object)this.delegate, (Object[])new Object[]{this.traceRunnableWhenContextReady(task)});
    }

    public boolean prefersShortLivedTasks() {
        return this.delegate.prefersShortLivedTasks();
    }

    @Nullable
    public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
        return this.delegate.schedule(this.traceRunnableWhenContextReady(task), trigger);
    }

    public ScheduledFuture<?> schedule(Runnable task, Date startTime) {
        return this.delegate.schedule(this.traceRunnableWhenContextReady(task), startTime);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Date startTime, long period) {
        return this.delegate.scheduleAtFixedRate(this.traceRunnableWhenContextReady(task), startTime, period);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long period) {
        return this.delegate.scheduleAtFixedRate(this.traceRunnableWhenContextReady(task), period);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Date startTime, long delay) {
        return this.delegate.scheduleWithFixedDelay(this.traceRunnableWhenContextReady(task), startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long delay) {
        return this.delegate.scheduleWithFixedDelay(this.traceRunnableWhenContextReady(task), delay);
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.delegate.setThreadFactory(threadFactory);
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.delegate.setThreadNamePrefix(threadNamePrefix);
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.delegate.setRejectedExecutionHandler(rejectedExecutionHandler);
    }

    public void setWaitForTasksToCompleteOnShutdown(boolean waitForJobsToCompleteOnShutdown) {
        this.delegate.setWaitForTasksToCompleteOnShutdown(waitForJobsToCompleteOnShutdown);
    }

    public void setAwaitTerminationSeconds(int awaitTerminationSeconds) {
        this.delegate.setAwaitTerminationSeconds(awaitTerminationSeconds);
    }

    public void setBeanName(String name) {
        this.delegate.setBeanName(name);
    }

    public void afterPropertiesSet() {
        this.delegate.afterPropertiesSet();
    }

    public void initialize() {
        this.delegate.initialize();
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    public Thread newThread(Runnable runnable) {
        return this.delegate.newThread(this.traceRunnableWhenContextReady(runnable));
    }

    public String getThreadNamePrefix() {
        return this.delegate.getThreadNamePrefix();
    }

    public void setThreadPriority(int threadPriority) {
        this.delegate.setThreadPriority(threadPriority);
    }

    public int getThreadPriority() {
        return this.delegate.getThreadPriority();
    }

    public void setDaemon(boolean daemon) {
        this.delegate.setDaemon(daemon);
    }

    public boolean isDaemon() {
        return this.delegate.isDaemon();
    }

    public void setThreadGroupName(String name) {
        this.delegate.setThreadGroupName(name);
    }

    public void setThreadGroup(ThreadGroup threadGroup) {
        this.delegate.setThreadGroup(threadGroup);
    }

    @Nullable
    public ThreadGroup getThreadGroup() {
        return this.delegate.getThreadGroup();
    }

    public Thread createThread(Runnable runnable) {
        return this.delegate.createThread(this.traceRunnableWhenContextReady(runnable));
    }

    public String nextThreadName() {
        return (String)ReflectionUtils.invokeMethod((Method)this.nextThreadName, (Object)this.delegate);
    }

    public String getDefaultThreadNamePrefix() {
        if (this.delegate == null) {
            return super.getDefaultThreadNamePrefix();
        }
        return (String)ReflectionUtils.invokeMethod((Method)this.getDefaultThreadNamePrefix, (Object)this.delegate);
    }

    public ScheduledFuture<?> schedule(Runnable task, Instant startTime) {
        return this.delegate.schedule(this.traceRunnableWhenContextReady(task), startTime);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Instant startTime, Duration period) {
        return this.delegate.scheduleAtFixedRate(this.traceRunnableWhenContextReady(task), startTime, period);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Duration period) {
        return this.delegate.scheduleAtFixedRate(this.traceRunnableWhenContextReady(task), period);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Instant startTime, Duration delay) {
        return this.delegate.scheduleWithFixedDelay(this.traceRunnableWhenContextReady(task), startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Duration delay) {
        return this.delegate.scheduleWithFixedDelay(this.traceRunnableWhenContextReady(task), delay);
    }

    private Tracer tracing() {
        if (this.tracing == null) {
            this.tracing = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracing;
    }

    private SpanNamer spanNamer() {
        if (this.spanNamer == null) {
            try {
                this.spanNamer = (SpanNamer)this.beanFactory.getBean(SpanNamer.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                log.warn((Object)"SpanNamer bean not found - will provide a manually created instance");
                return new DefaultSpanNamer();
            }
        }
        return this.spanNamer;
    }
}

