/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

class SleuthContextOperator<T>
implements Subscription,
CoreSubscriber<T>,
Scannable {
    private final Context context;
    private final Subscriber<? super T> subscriber;
    private Subscription s;

    SleuthContextOperator(Context context, Subscriber<? super T> subscriber) {
        this.context = context;
        this.subscriber = subscriber;
    }

    public void onSubscribe(Subscription subscription) {
        this.s = subscription;
        this.subscriber.onSubscribe((Subscription)this);
    }

    public void request(long n) {
        this.s.request(n);
    }

    public void cancel() {
        this.s.cancel();
    }

    public void onNext(T o) {
        this.subscriber.onNext(o);
    }

    public void onError(Throwable throwable) {
        this.subscriber.onError(throwable);
    }

    public void onComplete() {
        this.subscriber.onComplete();
    }

    public Context currentContext() {
        return this.context;
    }

    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }
}

