/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.quartz;

import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.quartz.SleuthQuartzSpan;
import org.springframework.cloud.sleuth.propagation.Propagator;

public class TracingJobListener
implements JobListener,
TriggerListener {
    static final String CONTEXT_SPAN_KEY = Span.class.getName();
    static final String CONTEXT_SPAN_IN_SCOPE_KEY = Tracer.SpanInScope.class.getName();
    private static final Propagator.Getter<JobDataMap> GETTER = (carrier, key) -> {
        Object value = carrier.get((Object)key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    };
    private final Tracer tracer;
    private final Propagator propagator;

    public TracingJobListener(Tracer tracer, Propagator propagator) {
        this.tracer = tracer;
        this.propagator = propagator;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
        Span nextSpan = this.propagator.extract((Object)context.getMergedJobDataMap(), GETTER).start();
        AssertingSpan span = SleuthQuartzSpan.QUARTZ_TRIGGER_SPAN.wrap(nextSpan).tag((TagKey)SleuthQuartzSpan.Tags.TRIGGER, context.getTrigger().getKey().toString()).name(context.getTrigger().getJobKey().toString());
        context.put((Object)CONTEXT_SPAN_KEY, (Object)span);
        context.put((Object)CONTEXT_SPAN_IN_SCOPE_KEY, (Object)this.tracer.withSpan((Span)span.start()));
    }

    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        return false;
    }

    public void triggerMisfired(Trigger trigger) {
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, Trigger.CompletedExecutionInstruction triggerInstructionCode) {
        this.closeTrace(context);
    }

    public void jobToBeExecuted(JobExecutionContext context) {
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        this.closeTrace(context);
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
    }

    private void closeTrace(JobExecutionContext context) {
        Object spanInScope = context.get((Object)CONTEXT_SPAN_IN_SCOPE_KEY);
        Object span = context.get((Object)CONTEXT_SPAN_KEY);
        if (spanInScope instanceof Tracer.SpanInScope) {
            ((Tracer.SpanInScope)spanInScope).close();
        }
        if (span instanceof Span) {
            ((Span)span).end();
        }
    }
}

