/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.concurrent.Executor;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceExecutor;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;

public class LazyTraceAsyncCustomizer
extends AsyncConfigurerSupport {
    private final BeanFactory beanFactory;
    private final AsyncConfigurer delegate;

    public LazyTraceAsyncCustomizer(BeanFactory beanFactory, AsyncConfigurer delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    public Executor getAsyncExecutor() {
        Executor executor = this.delegate.getAsyncExecutor();
        if (executor instanceof LazyTraceExecutor) {
            return executor;
        }
        if (executor == null) {
            return null;
        }
        return LazyTraceExecutor.wrap(this.beanFactory, executor);
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return this.delegate.getAsyncUncaughtExceptionHandler();
    }
}

