/*
 * Copyright 2013-2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.sleuth.autoconfig.otel;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Sleuth settings for OpenTelemetry.
 *
 * @author Marcin Grzejszczak
 * @since 1.0.0
 */
@ConfigurationProperties("spring.sleuth.otel.log")
public class OtelLogProperties {

	private Exporter exporter = new Exporter();

	private Slf4j slf4j = new Slf4j();

	public Exporter getExporter() {
		return this.exporter;
	}

	public void setExporter(Exporter exporter) {
		this.exporter = exporter;
	}

	public Slf4j getSlf4j() {
		return this.slf4j;
	}

	public void setSlf4j(Slf4j slf4j) {
		this.slf4j = slf4j;
	}

	public static class Exporter {

		/**
		 * Enable log exporter for OTel.
		 */
		private boolean enabled = false;

		public boolean isEnabled() {
			return this.enabled;
		}

		public void setEnabled(boolean enabled) {
			this.enabled = enabled;
		}

	}

	public static class Slf4j {

		/**
		 * Enable slf4j support for OTel.
		 */
		private boolean enabled;

		public boolean isEnabled() {
			return this.enabled;
		}

		public void setEnabled(boolean enabled) {
			this.enabled = enabled;
		}

	}

}
