/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.SamplerFunction;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.http.HttpClientRequest;
import org.springframework.cloud.sleuth.http.HttpClientResponse;
import org.springframework.cloud.sleuth.http.HttpRequest;
import org.springframework.cloud.sleuth.http.HttpRequestParser;
import org.springframework.cloud.sleuth.http.HttpResponse;
import org.springframework.cloud.sleuth.http.HttpResponseParser;
import org.springframework.cloud.sleuth.otel.bridge.HttpRequestNetClientAttributesExtractor;
import org.springframework.cloud.sleuth.otel.bridge.OtelSpan;
import org.springframework.cloud.sleuth.otel.bridge.OtelTraceContext;
import org.springframework.cloud.sleuth.otel.bridge.PathAttributeExtractor;
import org.springframework.cloud.sleuth.otel.bridge.SpringHttpClientAttributesExtractor;
import org.springframework.lang.Nullable;

public class OtelHttpClientHandler
implements HttpClientHandler {
    private static final Log log = LogFactory.getLog(OtelHttpClientHandler.class);
    private static final ContextKey<HttpClientRequest> REQUEST_CONTEXT_KEY = ContextKey.named((String)(OtelHttpClientHandler.class.getName() + ".request"));
    private final HttpRequestParser httpClientRequestParser;
    private final HttpResponseParser httpClientResponseParser;
    private final SamplerFunction<HttpRequest> samplerFunction;
    private final Instrumenter<HttpClientRequest, HttpClientResponse> instrumenter;

    public OtelHttpClientHandler(OpenTelemetry openTelemetry, @Nullable HttpRequestParser httpClientRequestParser, @Nullable HttpResponseParser httpClientResponseParser, SamplerFunction<HttpRequest> samplerFunction) {
        this.httpClientRequestParser = httpClientRequestParser;
        this.httpClientResponseParser = httpClientResponseParser;
        this.samplerFunction = samplerFunction;
        SpringHttpClientAttributesExtractor httpAttributesExtractor = new SpringHttpClientAttributesExtractor();
        this.instrumenter = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"org.springframework.cloud.sleuth", (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesExtractor)httpAttributesExtractor)).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesExtractor)httpAttributesExtractor)).addAttributesExtractor((AttributesExtractor)new HttpRequestNetClientAttributesExtractor()).addAttributesExtractor((AttributesExtractor)httpAttributesExtractor).addAttributesExtractor((AttributesExtractor)new PathAttributeExtractor()).newClientInstrumenter(HttpClientRequest::header);
    }

    public Span handleSend(HttpClientRequest request) {
        Context parentContext = Context.current();
        return this.startSpan(request, parentContext);
    }

    public Span handleSend(HttpClientRequest request, TraceContext parent) {
        Context parentContext = OtelTraceContext.toOtelContext(parent);
        return this.startSpan(request, parentContext);
    }

    private Span startSpan(HttpClientRequest request, Context parentContext) {
        if (Boolean.FALSE.equals(this.samplerFunction.trySample((Object)request))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning an invalid span since url [" + request.path() + "] is on a list of urls to skip"));
            }
            return OtelSpan.fromOtel(io.opentelemetry.api.trace.Span.getInvalid());
        }
        if (this.instrumenter.shouldStart(parentContext, (Object)request)) {
            Context context = this.instrumenter.start(parentContext, (Object)request);
            return this.span(context, request);
        }
        return OtelSpan.fromOtel(io.opentelemetry.api.trace.Span.getInvalid());
    }

    private Span span(Context context, HttpClientRequest request) {
        io.opentelemetry.api.trace.Span span = io.opentelemetry.api.trace.Span.fromContext((Context)context);
        Span result = OtelSpan.fromOtel(span, context.with(REQUEST_CONTEXT_KEY, (Object)request));
        if (this.httpClientRequestParser != null) {
            this.httpClientRequestParser.parse((HttpRequest)request, result.context(), (SpanCustomizer)result);
        }
        return result;
    }

    public void handleReceive(HttpClientResponse response, Span span) {
        OtelSpan otelSpanWrapper = (OtelSpan)span;
        if (!otelSpanWrapper.delegate.getSpanContext().isValid()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Not doing anything because the span is invalid");
            }
            return;
        }
        if (this.httpClientResponseParser != null) {
            this.httpClientResponseParser.parse((HttpResponse)response, span.context(), (SpanCustomizer)span);
        }
        OtelTraceContext traceContext = otelSpanWrapper.context();
        Context otelContext = traceContext.context();
        Context contextToEnd = Context.current().with((ImplicitContextKeyed)otelSpanWrapper.delegate);
        this.instrumenter.end(contextToEnd, otelContext.get(REQUEST_CONTEXT_KEY), (Object)response, response.error());
    }
}

