/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.sleuth.http.HttpServerRequest;
import org.springframework.cloud.sleuth.http.HttpServerResponse;
import org.springframework.lang.Nullable;

class SpringHttpServerAttributesExtractor
extends HttpServerAttributesExtractor<HttpServerRequest, HttpServerResponse> {
    SpringHttpServerAttributesExtractor() {
    }

    @Nullable
    protected String flavor(HttpServerRequest httpServerRequest) {
        return null;
    }

    @Nullable
    protected String target(HttpServerRequest httpServerRequest) {
        URI uri = this.toUri(httpServerRequest);
        if (uri == null) {
            return null;
        }
        return uri.getPath() + this.queryPart(uri);
    }

    private URI toUri(HttpServerRequest request) {
        String url = request.url();
        return url == null ? null : URI.create(url);
    }

    private String queryPart(URI uri) {
        String query = uri.getQuery();
        return query != null ? "?" + query : "";
    }

    @Nullable
    protected String route(HttpServerRequest httpServerRequest) {
        return httpServerRequest.route();
    }

    @Nullable
    protected String scheme(HttpServerRequest httpServerRequest) {
        String url = httpServerRequest.url();
        if (url == null) {
            return null;
        }
        if (url.startsWith("https:")) {
            return "https";
        }
        if (url.startsWith("http:")) {
            return "http";
        }
        return null;
    }

    @Nullable
    protected String serverName(HttpServerRequest httpServerRequest, @Nullable HttpServerResponse httpServerResponse) {
        return null;
    }

    @Nullable
    protected String method(HttpServerRequest httpServerRequest) {
        return httpServerRequest.method();
    }

    protected List<String> requestHeader(HttpServerRequest httpServerRequest, String name) {
        String value = httpServerRequest.header(name);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }

    @Nullable
    protected Long requestContentLength(HttpServerRequest httpServerRequest, @Nullable HttpServerResponse httpServerResponse) {
        return null;
    }

    @Nullable
    protected Long requestContentLengthUncompressed(HttpServerRequest httpServerRequest, @Nullable HttpServerResponse httpServerResponse) {
        return null;
    }

    @Nullable
    protected Integer statusCode(HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse) {
        return httpServerResponse.statusCode();
    }

    @Nullable
    protected Long responseContentLength(HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse) {
        return null;
    }

    @Nullable
    protected Long responseContentLengthUncompressed(HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse) {
        return null;
    }

    protected List<String> responseHeader(HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse, String name) {
        String value = httpServerResponse.header(name);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }
}

