/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.http.HttpRequest;
import org.springframework.cloud.sleuth.http.HttpRequestParser;
import org.springframework.cloud.sleuth.http.HttpResponse;
import org.springframework.cloud.sleuth.http.HttpResponseParser;
import org.springframework.cloud.sleuth.http.HttpServerHandler;
import org.springframework.cloud.sleuth.http.HttpServerRequest;
import org.springframework.cloud.sleuth.http.HttpServerResponse;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternProvider;
import org.springframework.cloud.sleuth.otel.bridge.HttpRequestNetServerAttributesExtractor;
import org.springframework.cloud.sleuth.otel.bridge.OtelSpan;
import org.springframework.cloud.sleuth.otel.bridge.OtelTraceContext;
import org.springframework.cloud.sleuth.otel.bridge.PathAttributeExtractor;
import org.springframework.util.StringUtils;

public class OtelHttpServerHandler
implements HttpServerHandler {
    private static final Log log = LogFactory.getLog(OtelHttpServerHandler.class);
    private static final ContextKey<HttpServerRequest> REQUEST_CONTEXT_KEY = ContextKey.named((String)(OtelHttpServerHandler.class.getName() + ".request"));
    private final HttpRequestParser httpServerRequestParser;
    private final HttpResponseParser httpServerResponseParser;
    private final Pattern pattern;
    private final Instrumenter<HttpServerRequest, HttpServerResponse> instrumenter;

    public OtelHttpServerHandler(OpenTelemetry openTelemetry, HttpRequestParser httpServerRequestParser, HttpResponseParser httpServerResponseParser, SkipPatternProvider skipPatternProvider, HttpServerAttributesGetter<HttpServerRequest, HttpServerResponse> httpAttributesGetter) {
        this.httpServerRequestParser = httpServerRequestParser;
        this.httpServerResponseParser = httpServerResponseParser;
        this.pattern = skipPatternProvider.skipPattern();
        this.instrumenter = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"org.springframework.cloud.sleuth", (SpanNameExtractor)HttpSpanNameExtractor.create(httpAttributesGetter)).setSpanStatusExtractor(HttpSpanStatusExtractor.create(httpAttributesGetter)).addAttributesExtractor(HttpServerAttributesExtractor.create(httpAttributesGetter, (NetServerAttributesGetter)new HttpRequestNetServerAttributesExtractor())).addAttributesExtractor((AttributesExtractor)new PathAttributeExtractor()).buildServerInstrumenter(this.getGetter());
    }

    public Span handleReceive(HttpServerRequest request) {
        boolean shouldSkip;
        String url = request.path();
        boolean bl = shouldSkip = !StringUtils.isEmpty((Object)url) && this.pattern.matcher(url).matches();
        if (shouldSkip) {
            return OtelSpan.fromOtel(io.opentelemetry.api.trace.Span.getInvalid());
        }
        Context parentContext = Context.current();
        if (this.instrumenter.shouldStart(parentContext, (Object)request)) {
            Context context = this.instrumenter.start(parentContext, (Object)request);
            return this.span(context, request);
        }
        return OtelSpan.fromOtel(io.opentelemetry.api.trace.Span.getInvalid());
    }

    private Span span(Context context, HttpServerRequest request) {
        io.opentelemetry.api.trace.Span span = io.opentelemetry.api.trace.Span.fromContext((Context)context);
        Span result = OtelSpan.fromOtel(span, context.with(REQUEST_CONTEXT_KEY, (Object)request));
        if (this.httpServerRequestParser != null) {
            this.httpServerRequestParser.parse((HttpRequest)request, result.context(), (SpanCustomizer)result);
        }
        return result;
    }

    public void handleSend(HttpServerResponse response, Span span) {
        OtelSpan otelSpanWrapper = (OtelSpan)AssertingSpan.unwrap((Span)span);
        if (!otelSpanWrapper.delegate.getSpanContext().isValid()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Not doing anything because the span is invalid");
            }
            return;
        }
        if (this.httpServerResponseParser != null) {
            this.httpServerResponseParser.parse((HttpResponse)response, span.context(), (SpanCustomizer)span);
        }
        OtelTraceContext traceContext = otelSpanWrapper.context();
        Context otelContext = traceContext.context();
        this.instrumenter.end(otelContext, otelContext.get(REQUEST_CONTEXT_KEY), (Object)response, response.error());
    }

    private TextMapGetter<HttpServerRequest> getGetter() {
        return new TextMapGetter<HttpServerRequest>(){

            public Iterable<String> keys(HttpServerRequest carrier) {
                return carrier.headerNames();
            }

            public String get(HttpServerRequest carrier, String key) {
                return carrier.header(key);
            }
        };
    }
}

