/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.instrument.web.mvc.TracingClientHttpRequestInterceptor;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;
import org.springframework.cloud.sleuth.test.TracerAware;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.test.web.client.MockMvcClientHttpRequestFactory;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

public abstract class TraceRestTemplateInterceptorTests
implements TestTracingAwareSupplier {
    private TestController testController = new TestController();
    private MockMvc mockMvc = MockMvcBuilders.standaloneSetup((Object[])new Object[]{this.testController}).build();
    private RestTemplate template = new RestTemplate((ClientHttpRequestFactory)new MockMvcClientHttpRequestFactory(this.mockMvc));
    Tracer tracer = this.tracerTest().tracing().tracer();
    TestSpanHandler spans = this.tracerTest().handler();

    @BeforeEach
    public void setup() {
        this.setInterceptors(this.tracerTest().tracing().httpClientHandler());
    }

    private void setInterceptors(HttpClientHandler httpClientHandler) {
        this.template.setInterceptors(Arrays.asList(TracingClientHttpRequestInterceptor.create((CurrentTraceContext)this.tracerTest().tracing().currentTraceContext(), (HttpClientHandler)httpClientHandler)));
    }

    @AfterEach
    public void clean() {
        this.tracerTest().close();
    }

    @Test
    public void headersAddedWhenNoTracingWasPresent() {
        Map headers = (Map)this.template.getForEntity("/", Map.class, new Object[0]).getBody();
        BDDAssertions.then((String)((String)headers.get("X-B3-TraceId"))).isNotNull();
        BDDAssertions.then((String)((String)headers.get("X-B3-SpanId"))).isNotNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void headersAddedWhenTracing() {
        Map headers;
        Span span = this.tracer.nextSpan().name("new trace");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            headers = (Map)this.template.getForEntity("/", Map.class, new Object[0]).getBody();
        }
        finally {
            span.end();
        }
        BDDAssertions.then((String)((String)headers.get("X-B3-TraceId"))).isEqualTo(span.context().traceId());
        BDDAssertions.then((String)((String)headers.get("X-B3-SpanId"))).isNotEqualTo((Object)span.context().spanId());
        this.assertThatParentSpanIdSet(span, headers);
    }

    public void assertThatParentSpanIdSet(Span span, Map<String, String> headers) {
        throw new UnsupportedOperationException("Implement this assertion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void requestHeadersAddedWhenTracing() {
        this.setInterceptors(this.tracerTest().tracing().clientRequestParser((request, context, span) -> span.tag("http.url", request.url()).tag("http.method", request.method()).tag("http.path", request.path()).name(request.method())).httpClientHandler());
        Span span2 = this.tracer.nextSpan().name("new trace");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span2.start());){
            this.template.getForEntity("/foo?a=b", Map.class, new Object[0]);
        }
        finally {
            span2.end();
        }
        BDDAssertions.then((Iterable)this.spans).isNotEmpty();
        ((MapAssert)((MapAssert)BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"http.url", (Object)"/foo?a=b")).containsEntry((Object)"http.path", (Object)"/foo")).containsEntry((Object)"http.method", (Object)"GET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void notSampledHeaderAddedWhenNotSampled() {
        this.template.setInterceptors(Arrays.asList(TracingClientHttpRequestInterceptor.create((CurrentTraceContext)this.tracerTest().tracing().currentTraceContext(), (HttpClientHandler)this.tracerTest().tracing().sampler(TracerAware.TraceSampler.OFF).httpClientHandler())));
        this.spans = this.tracerTest().handler();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("new trace");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.template.getForEntity("/", Map.class, new Object[0]).getBody();
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Iterable)this.spans).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void spanRemovedFromThreadUponException() {
        Span span = this.tracer.nextSpan().name("new trace");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            this.template.getForEntity("/exception", Map.class, new Object[0]).getBody();
            Assertions.fail((String)"should throw an exception");
        }
        catch (RuntimeException e) {
            BDDAssertions.then((Throwable)e).hasMessageStartingWith("500 Internal Server Error");
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createdSpanNameHasOnlyPrintableAsciiCharactersForNonEncodedURIWithNonAsciiChars() {
        Span span = this.tracer.nextSpan().name("new trace");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            this.template.getForEntity("/cas~fs~\u00e5\u02c6\u2019", Map.class, new Object[0]).getBody();
        }
        catch (Exception exception) {
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Iterable)this.spans).hasSize(2);
    }

    @RestController
    public class TestController {
        Span span;

        @RequestMapping(value={"/"})
        public Map<String, String> home(@RequestHeader HttpHeaders headers) {
            this.span = TraceRestTemplateInterceptorTests.this.tracer.currentSpan();
            HashMap<String, String> map = new HashMap<String, String>();
            this.addHeaders(map, headers, "X-B3-SpanId", "X-B3-TraceId", "X-B3-ParentSpanId");
            return map;
        }

        @RequestMapping(value={"/foo"})
        public void foo() {
        }

        @RequestMapping(value={"/exception"})
        public Map<String, String> exception() {
            throw new RuntimeException("foo");
        }

        private void addHeaders(Map<String, String> map, HttpHeaders headers, String ... names) {
            if (headers != null) {
                for (String name : names) {
                    String value = headers.getFirst(name);
                    if (value == null) continue;
                    map.put(name, value);
                }
            }
        }
    }
}

