/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import java.io.IOException;
import java.util.HashMap;
import org.assertj.core.api.BDDAssertions;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.stubbing.Answer;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TracingFeignClient;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;

@ExtendWith(value={MockitoExtension.class})
public abstract class TracingFeignClientTests
implements TestTracingAwareSupplier {
    RequestTemplate requestTemplate = new RequestTemplate();
    Request request = Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"https://foo", new HashMap(), null, null, (RequestTemplate)this.requestTemplate);
    Request.Options options = new Request.Options();
    @Mock
    Client client;
    Client traceFeignClient;

    @BeforeEach
    public void setup() {
        this.traceFeignClient = TracingFeignClient.create((CurrentTraceContext)this.tracerTest().tracing().currentTraceContext(), (HttpClientHandler)this.tracerTest().tracing().httpClientHandler(), (Client)this.client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_log_cr_when_response_successful() throws IOException {
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceFeignClient.execute(this.request, this.options);
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Comparable)this.tracerTest().handler().reportedSpans().get(0).getKind()).isEqualTo((Object)Span.Kind.CLIENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_log_error_when_exception_thrown() throws IOException {
        RuntimeException error = new RuntimeException("exception has occurred");
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        BDDMockito.given((Object)this.client.execute((Request)BDDMockito.any(), (Request.Options)BDDMockito.any())).willThrow(new Throwable[]{error});
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceFeignClient.execute(this.request, this.options);
            BDDAssertions.fail((String)"Exception should have been thrown");
        }
        catch (Exception exception) {
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Comparable)this.tracerTest().handler().reportedSpans().get(0).getKind()).isEqualTo((Object)Span.Kind.CLIENT);
        this.assertException(error);
    }

    public void assertException(RuntimeException error) {
        throw new UnsupportedOperationException("Implement this assertion");
    }

    @Test
    public void keep_requestTemplate() throws IOException {
        BDDMockito.given((Object)this.client.execute((Request)BDDMockito.any(), (Request.Options)BDDMockito.any())).willAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                Assert.assertEquals((Object)((Request)args[0]).requestTemplate(), (Object)TracingFeignClientTests.this.requestTemplate);
                return null;
            }
        });
        this.traceFeignClient.execute(this.request, this.options);
    }
}

