/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.baggage;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.sleuth.BaggageInScope;
import org.springframework.cloud.sleuth.ScopedSpan;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;

@ContextConfiguration(classes={TestConfig.class})
@TestPropertySource(properties={"spring.sleuth.baggage.remote-fields[0]=country-code", "spring.sleuth.baggage.remote-fields[1]=x-vcap-request-id", "spring.sleuth.baggage.tag-fields[0]=country-code"})
public abstract class BaggageEntryTagSpanHandlerTest {
    BaggageInScope countryCode;
    BaggageInScope requestId;
    @Autowired
    private Tracer tracer;
    @Autowired
    private TestSpanHandler spans;
    private ScopedSpan span;

    @BeforeEach
    public void setUp() {
        this.spans.clear();
        this.span = this.tracer.startScopedSpan("my-scoped-span");
        this.countryCode = this.tracer.createBaggage("country-code");
        this.countryCode.set("FO");
        this.requestId = this.tracer.createBaggage("x-vcap-request-id");
        this.requestId.set("f4308d05-2228-4468-80f6-92a8377ba193");
    }

    @Test
    public void shouldReportWithBaggageInTags() {
        this.span.end();
        Assertions.assertThat((Iterable)this.spans).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)this.spans.get(0).getTags()).hasSize(1)).containsEntry((Object)this.countryCode.name(), (Object)"FO");
    }

    @EnableAutoConfiguration
    @Configuration(proxyBeanMethods=false)
    static class TestConfig {
        TestConfig() {
        }
    }
}

