/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave;

import brave.Span;
import brave.test.IntegrationTestSpanHandler;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.ListAssert;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.brave.bridge.BraveAccessor;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.test.TestSpanHandler;

public class BraveTestSpanHandler
implements TestSpanHandler {
    final brave.test.TestSpanHandler spans;
    final IntegrationTestSpanHandler integrationSpans;

    public BraveTestSpanHandler(brave.test.TestSpanHandler spans) {
        this.spans = spans;
        this.integrationSpans = null;
    }

    public BraveTestSpanHandler(IntegrationTestSpanHandler integrationSpans) {
        this.spans = null;
        this.integrationSpans = integrationSpans;
    }

    public BraveTestSpanHandler(brave.test.TestSpanHandler spans, IntegrationTestSpanHandler integrationSpans) {
        this.spans = spans;
        this.integrationSpans = integrationSpans;
    }

    @Override
    public List<FinishedSpan> reportedSpans() {
        return this.spans.spans().stream().map(BraveAccessor::finishedSpan).collect(Collectors.toList());
    }

    @Override
    public FinishedSpan takeLocalSpan() {
        return BraveAccessor.finishedSpan(this.integrationSpans.takeLocalSpan());
    }

    @Override
    public void clear() {
        if (this.spans != null) {
            this.spans.clear();
        }
    }

    @Override
    public FinishedSpan takeRemoteSpan(Span.Kind kind) {
        return BraveAccessor.finishedSpan(this.integrationSpans.takeRemoteSpan(Span.Kind.valueOf((String)kind.name())));
    }

    @Override
    public FinishedSpan takeRemoteSpanWithError(Span.Kind kind) {
        return BraveAccessor.finishedSpan(this.integrationSpans.takeRemoteSpanWithError(Span.Kind.valueOf((String)kind.name())));
    }

    @Override
    public FinishedSpan get(int index) {
        return BraveAccessor.finishedSpan(this.spans.get(index));
    }

    @Override
    public void assertAllSpansWereFinishedOrAbandoned(Queue<Span> createdSpans) {
        List<FinishedSpan> finishedSpans = this.reportedSpans();
        ((ListAssert)BDDAssertions.then(finishedSpans).as("There should be that many finished spans as many created ones", new Object[0])).hasSize(createdSpans.size());
        List matchedFinishedSpans = finishedSpans.stream().filter(f -> createdSpans.stream().anyMatch(cs -> f.getSpanId().equals(cs.context().spanId()))).collect(Collectors.toList());
        List matchedCreatedSpans = createdSpans.stream().filter(cs -> finishedSpans.stream().anyMatch(f -> cs.context().spanId().equals(f.getSpanId()))).collect(Collectors.toList());
        List missingFinishedSpans = finishedSpans.stream().filter(f -> matchedFinishedSpans.stream().noneMatch(m -> m.getSpanId().equals(f.getSpanId()))).collect(Collectors.toList());
        List missingCreatedSpans = createdSpans.stream().filter(f -> matchedCreatedSpans.stream().noneMatch(m -> m.context().spanId().equals(f.context().spanId()))).collect(Collectors.toList());
        if (!missingFinishedSpans.isEmpty() || !missingCreatedSpans.isEmpty()) {
            throw new AssertionError((Object)("There were unmatched created spans " + missingCreatedSpans + " and/or finished span " + missingFinishedSpans));
        }
    }

    @Override
    public Iterator<FinishedSpan> iterator() {
        return this.reportedSpans().iterator();
    }

    public String toString() {
        return "BraveTestSpanHandler{spans=" + this.spans + ", integrationSpans=" + this.integrationSpans + '}';
    }
}

