/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import org.aspectj.lang.ProceedingJoinPoint;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignAspect;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TracingFeignClient;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;

@ExtendWith(value={MockitoExtension.class})
public abstract class TraceFeignAspectTests
implements TestTracingAwareSupplier {
    @Mock
    BeanFactory beanFactory;
    @Mock
    Client client;
    @Mock
    ProceedingJoinPoint pjp;
    TraceFeignAspect traceFeignAspect;

    @BeforeEach
    public void setup() {
        this.traceFeignAspect = new TraceFeignAspect(this.beanFactory){

            Object executeTraceFeignClient(Object bean, ProceedingJoinPoint pjp) {
                return null;
            }
        };
    }

    @Test
    public void should_wrap_feign_client_in_trace_representation() throws Throwable {
        BDDMockito.given((Object)this.pjp.getTarget()).willReturn((Object)this.client);
        this.traceFeignAspect.feignClientWasCalled(this.pjp);
        ((ProceedingJoinPoint)Mockito.verify((Object)this.pjp, (VerificationMode)Mockito.never())).proceed();
    }

    @Test
    public void should_not_wrap_traced_feign_client_in_trace_representation() throws Throwable {
        BDDMockito.given((Object)this.pjp.getTarget()).willReturn((Object)new TracingFeignClient(this.tracerTest().tracing().currentTraceContext(), this.tracerTest().tracing().httpClientHandler(), this.client));
        this.traceFeignAspect.feignClientWasCalled(this.pjp);
        ((ProceedingJoinPoint)Mockito.verify((Object)this.pjp)).proceed();
    }
}

