/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin;

import java.lang.invoke.MethodHandles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.sleuth.zipkin.EndpointLocator;
import org.springframework.cloud.sleuth.zipkin.ZipkinProperties;
import org.springframework.util.StringUtils;
import zipkin.Endpoint;

public class DiscoveryClientEndpointLocator
implements EndpointLocator {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final DiscoveryClient client;
    private final ZipkinProperties zipkinProperties;

    @Deprecated
    public DiscoveryClientEndpointLocator(DiscoveryClient client) {
        this(client, new ZipkinProperties());
    }

    public DiscoveryClientEndpointLocator(DiscoveryClient client, ZipkinProperties zipkinProperties) {
        this.client = client;
        this.zipkinProperties = zipkinProperties;
    }

    @Override
    public Endpoint local() {
        String serviceName;
        ServiceInstance instance = this.client.getLocalServiceInstance();
        if (instance == null) {
            throw new NoServiceInstanceAvailableException();
        }
        String string = serviceName = StringUtils.hasText((String)this.zipkinProperties.getService().getName()) ? this.zipkinProperties.getService().getName() : instance.getServiceId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Span will contain serviceName [" + serviceName + "]"));
        }
        return Endpoint.builder().serviceName(serviceName).ipv4(this.getIpAddress(instance)).port(instance.getPort()).build();
    }

    private int getIpAddress(ServiceInstance instance) {
        try {
            return InetUtils.getIpAddressAsInt((String)instance.getHost());
        }
        catch (Exception e) {
            return 0;
        }
    }

    static class NoServiceInstanceAvailableException
    extends RuntimeException {
        NoServiceInstanceAvailableException() {
        }
    }
}

