/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin2;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.servlet.context.ServletWebServerInitializedEvent;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;
import org.springframework.cloud.sleuth.zipkin2.EndpointLocator;
import org.springframework.cloud.sleuth.zipkin2.ZipkinProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import zipkin2.Endpoint;

@Deprecated
public class DefaultEndpointLocator
implements EndpointLocator,
ApplicationListener<ServletWebServerInitializedEvent> {
    private static final Log log = LogFactory.getLog(DefaultEndpointLocator.class);
    private static final String IP_ADDRESS_PROP_NAME = "spring.cloud.client.ipAddress";
    private final Registration registration;
    private final ServerProperties serverProperties;
    private final Environment environment;
    private final ZipkinProperties zipkinProperties;
    private Integer port;
    private InetAddress firstNonLoopbackAddress;

    public DefaultEndpointLocator(Registration registration, ServerProperties serverProperties, Environment environment, ZipkinProperties zipkinProperties, InetUtils inetUtils) {
        this.registration = registration;
        this.serverProperties = serverProperties;
        this.environment = environment;
        this.zipkinProperties = zipkinProperties;
        this.firstNonLoopbackAddress = this.findFirstNonLoopbackAddress(inetUtils);
    }

    private InetAddress findFirstNonLoopbackAddress(InetUtils inetUtils) {
        if (inetUtils == null) {
            inetUtils = new InetUtils(new InetUtilsProperties());
        }
        return inetUtils.findFirstNonLoopbackAddress();
    }

    @Override
    public Endpoint local() {
        String serviceName = this.getLocalServiceName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Span will contain serviceName [" + serviceName + "]"));
        }
        Endpoint.Builder builder = Endpoint.newBuilder().serviceName(serviceName).port(this.getPort());
        return this.addAddress(builder).build();
    }

    private String getLocalServiceName() {
        if (StringUtils.hasText((String)this.zipkinProperties.getService().getName())) {
            return this.zipkinProperties.getService().getName();
        }
        if (this.registration != null) {
            try {
                return this.registration.getServiceId();
            }
            catch (RuntimeException e) {
                log.warn((Object)"error getting service name from registration", (Throwable)e);
            }
        }
        return this.environment.getProperty("spring.application.name", "unknown");
    }

    public void onApplicationEvent(ServletWebServerInitializedEvent event) {
        this.port = event.getSource().getPort();
    }

    private Integer getPort() {
        if (this.port != null) {
            return this.port;
        }
        Integer port = this.serverProperties != null && this.serverProperties.getPort() != null && this.serverProperties.getPort() > 0 ? this.serverProperties.getPort() : Integer.valueOf(8080);
        return port;
    }

    private Endpoint.Builder addAddress(Endpoint.Builder builder) {
        if (this.serverProperties != null && this.serverProperties.getAddress() != null && builder.parseIp(this.serverProperties.getAddress())) {
            return builder;
        }
        if (this.environment.containsProperty(IP_ADDRESS_PROP_NAME) && builder.parseIp((String)this.environment.getProperty(IP_ADDRESS_PROP_NAME, String.class))) {
            return builder;
        }
        return builder.ip(this.firstNonLoopbackAddress);
    }
}

