/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.column;

import com.datastax.driver.core.Cluster;
import org.springframework.cloud.service.AbstractServiceConnectorCreator;
import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.cloud.service.column.CassandraClusterConfig;
import org.springframework.cloud.service.common.CassandraServiceInfo;
import org.springframework.util.StringUtils;

public class CassandraClusterCreator
extends AbstractServiceConnectorCreator<Cluster, CassandraServiceInfo> {
    public Cluster create(CassandraServiceInfo serviceInfo, ServiceConnectorConfig serviceConnectorConfig) {
        Cluster.Builder builder = Cluster.builder().addContactPoints(serviceInfo.getContactPoints().toArray(new String[0])).withPort(serviceInfo.getPort());
        if (StringUtils.hasText((String)serviceInfo.getUsername())) {
            builder.withCredentials(serviceInfo.getUsername(), serviceInfo.getPassword());
        }
        if (serviceConnectorConfig instanceof CassandraClusterConfig) {
            CassandraClusterConfig config = (CassandraClusterConfig)serviceConnectorConfig;
            if (config.getCompression() != null) {
                builder.withCompression(config.getCompression());
            }
            builder.withPoolingOptions(config.getPoolingOptions());
            builder.withSocketOptions(config.getSocketOptions());
            builder.withQueryOptions(config.getQueryOptions());
            builder.withNettyOptions(config.getNettyOptions());
            builder.withLoadBalancingPolicy(config.getLoadBalancingPolicy());
            builder.withReconnectionPolicy(config.getReconnectionPolicy());
            builder.withRetryPolicy(config.getRetryPolicy());
            builder.withProtocolVersion(config.getProtocolVersion());
            if (!config.isMetricsEnabled()) {
                builder.withoutMetrics();
            }
            if (!config.isJmxReportingEnabled()) {
                builder.withoutJMXReporting();
            }
        }
        return builder.build();
    }
}

