/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.relational;

import org.apache.tomcat.jdbc.pool.DataSource;
import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.cloud.service.Util;
import org.springframework.cloud.service.common.RelationalServiceInfo;
import org.springframework.cloud.service.relational.DbcpLikePooledDataSourceCreator;
import org.springframework.cloud.service.relational.UrlDecodingDataSource;

public class TomcatJdbcPooledDataSourceCreator<SI extends RelationalServiceInfo>
extends DbcpLikePooledDataSourceCreator<SI> {
    public static final String TOMCAT_JDBC_DATASOURCE = "org.apache.tomcat.jdbc.pool.DataSource";

    @Override
    public javax.sql.DataSource create(RelationalServiceInfo serviceInfo, ServiceConnectorConfig serviceConnectorConfig, String driverClassName, String validationQuery) {
        if (Util.hasClass(TOMCAT_JDBC_DATASOURCE)) {
            logger.info("Found Tomcat JDBC connection pool on the classpath. Using it for DataSource connection pooling.");
            DataSource ds = new DataSource();
            this.setBasicDataSourceProperties((javax.sql.DataSource)ds, serviceInfo, serviceConnectorConfig, driverClassName, validationQuery);
            return new UrlDecodingDataSource((javax.sql.DataSource)ds, "url");
        }
        return null;
    }
}

