/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.autoconfigure.paramstore;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClientBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.aws.paramstore.AwsParamStoreProperties;
import org.springframework.cloud.aws.paramstore.AwsParamStorePropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={AwsParamStoreProperties.class})
@ConditionalOnClass(value={AWSSimpleSystemsManagement.class, AwsParamStorePropertySourceLocator.class})
@ConditionalOnProperty(prefix="aws.paramstore", name={"enabled"}, matchIfMissing=true)
public class AwsParamStoreBootstrapConfiguration {
    @Bean
    AwsParamStorePropertySourceLocator awsParamStorePropertySourceLocator(AWSSimpleSystemsManagement ssmClient, AwsParamStoreProperties properties) {
        return new AwsParamStorePropertySourceLocator(ssmClient, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    AWSSimpleSystemsManagement ssmClient() {
        return AWSSimpleSystemsManagementClientBuilder.defaultClient();
    }
}

