/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.kafka.streams.kstream.KTable;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.util.Assert;

class KTableBoundElementFactory
extends AbstractBindingTargetFactory<KTable> {
    KTableBoundElementFactory() {
        super(KTable.class);
    }

    public KTable createInput(String name) {
        KTableWrapperHandler wrapper = new KTableWrapperHandler();
        ProxyFactory proxyFactory = new ProxyFactory(new Class[]{KTableWrapper.class, KTable.class});
        proxyFactory.addAdvice((Advice)wrapper);
        return (KTable)proxyFactory.getProxy();
    }

    public KTable createOutput(String name) {
        throw new UnsupportedOperationException("Outbound operations are not allowed on target type KTable");
    }

    private static class KTableWrapperHandler
    implements KTableWrapper,
    MethodInterceptor {
        private KTable<Object, Object> delegate;

        private KTableWrapperHandler() {
        }

        @Override
        public void wrap(KTable<Object, Object> delegate) {
            Assert.notNull(delegate, (String)"delegate cannot be null");
            Assert.isNull(this.delegate, (String)("delegate already set to " + this.delegate));
            this.delegate = delegate;
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            if (methodInvocation.getMethod().getDeclaringClass().equals(KTable.class)) {
                Assert.notNull(this.delegate, (String)("Trying to invoke " + methodInvocation.getMethod() + "  but no delegate has been set."));
                return methodInvocation.getMethod().invoke(this.delegate, methodInvocation.getArguments());
            }
            if (methodInvocation.getMethod().getDeclaringClass().equals(KTableWrapper.class)) {
                return methodInvocation.getMethod().invoke((Object)this, methodInvocation.getArguments());
            }
            throw new IllegalStateException("Only KStream method invocations are permitted");
        }
    }

    public static interface KTableWrapper {
        public void wrap(KTable<Object, Object> var1);
    }
}

