/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.Set;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binder.kafka.streams.QueryableStoreRegistry;
import org.springframework.context.SmartLifecycle;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.core.StreamsBuilderFactoryBean;

class StreamsBuilderFactoryManager
implements SmartLifecycle {
    private final KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue;
    private final QueryableStoreRegistry queryableStoreRegistry;
    private volatile boolean running;

    StreamsBuilderFactoryManager(KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue, QueryableStoreRegistry queryableStoreRegistry) {
        this.kafkaStreamsBindingInformationCatalogue = kafkaStreamsBindingInformationCatalogue;
        this.queryableStoreRegistry = queryableStoreRegistry;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        if (callback != null) {
            callback.run();
        }
    }

    public synchronized void start() {
        if (!this.running) {
            try {
                Set<StreamsBuilderFactoryBean> streamsBuilderFactoryBeans = this.kafkaStreamsBindingInformationCatalogue.getStreamsBuilderFactoryBeans();
                for (StreamsBuilderFactoryBean streamsBuilderFactoryBean : streamsBuilderFactoryBeans) {
                    streamsBuilderFactoryBean.start();
                    this.queryableStoreRegistry.registerKafkaStreams(streamsBuilderFactoryBean.getKafkaStreams());
                }
                this.running = true;
            }
            catch (Exception e) {
                throw new KafkaException("Could not start stream: ", (Throwable)e);
            }
        }
    }

    public synchronized void stop() {
        if (this.running) {
            try {
                Set<StreamsBuilderFactoryBean> streamsBuilderFactoryBeans = this.kafkaStreamsBindingInformationCatalogue.getStreamsBuilderFactoryBeans();
                for (StreamsBuilderFactoryBean streamsBuilderFactoryBean : streamsBuilderFactoryBeans) {
                    streamsBuilderFactoryBean.stop();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                this.running = false;
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 2147483547;
    }
}

