/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams.function;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsFunctionProcessor;
import org.springframework.cloud.stream.binder.kafka.streams.function.KafkaStreamsBindableProxyFactory;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.core.ResolvableType;
import org.springframework.util.StringUtils;

public class KafkaStreamsFunctionProcessorInvoker {
    private final KafkaStreamsFunctionProcessor kafkaStreamsFunctionProcessor;
    private final Map<String, ResolvableType> resolvableTypeMap;
    private final KafkaStreamsBindableProxyFactory[] kafkaStreamsBindableProxyFactories;
    private final Map<String, Method> methods;
    private final StreamFunctionProperties streamFunctionProperties;

    public KafkaStreamsFunctionProcessorInvoker(Map<String, ResolvableType> resolvableTypeMap, KafkaStreamsFunctionProcessor kafkaStreamsFunctionProcessor, KafkaStreamsBindableProxyFactory[] kafkaStreamsBindableProxyFactories, Map<String, Method> methods, StreamFunctionProperties streamFunctionProperties) {
        this.kafkaStreamsFunctionProcessor = kafkaStreamsFunctionProcessor;
        this.resolvableTypeMap = resolvableTypeMap;
        this.kafkaStreamsBindableProxyFactories = kafkaStreamsBindableProxyFactories;
        this.methods = methods;
        this.streamFunctionProperties = streamFunctionProperties;
    }

    @PostConstruct
    void invoke() {
        String[] functionUnits;
        String definition = this.streamFunctionProperties.getDefinition();
        String[] stringArray = functionUnits = StringUtils.hasText((String)definition) ? definition.split(";") : new String[]{};
        if (functionUnits.length == 0) {
            this.resolvableTypeMap.forEach((key, value) -> {
                Optional<KafkaStreamsBindableProxyFactory> proxyFactory = Arrays.stream(this.kafkaStreamsBindableProxyFactories).filter(p -> p.getFunctionName().equals(key)).findFirst();
                this.kafkaStreamsFunctionProcessor.setupFunctionInvokerForKafkaStreams((ResolvableType)value, (String)key, proxyFactory.get(), this.methods.get(key), null, new String[0]);
            });
        }
        for (String functionUnit : functionUnits) {
            if (functionUnit.contains("|")) {
                String[] composedFunctions = functionUnit.split("\\|");
                String[] derivedNameFromComposed = new String[]{""};
                for (String split : composedFunctions) {
                    derivedNameFromComposed[0] = derivedNameFromComposed[0].concat(split);
                }
                Optional<KafkaStreamsBindableProxyFactory> proxyFactory = Arrays.stream(this.kafkaStreamsBindableProxyFactories).filter(p -> p.getFunctionName().equals(derivedNameFromComposed[0])).findFirst();
                this.kafkaStreamsFunctionProcessor.setupFunctionInvokerForKafkaStreams(this.resolvableTypeMap.get(composedFunctions[0]), derivedNameFromComposed[0], proxyFactory.get(), this.methods.get(derivedNameFromComposed[0]), this.resolvableTypeMap.get(composedFunctions[composedFunctions.length - 1]), composedFunctions);
                continue;
            }
            Optional<KafkaStreamsBindableProxyFactory> proxyFactory = Arrays.stream(this.kafkaStreamsBindableProxyFactories).filter(p -> p.getFunctionName().equals(functionUnit)).findFirst();
            this.kafkaStreamsFunctionProcessor.setupFunctionInvokerForKafkaStreams(this.resolvableTypeMap.get(functionUnit), functionUnit, proxyFactory.get(), this.methods.get(functionUnit), null, new String[0]);
        }
    }
}

