/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.ToDoubleFunction;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.streams.KafkaStreams;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;

public class KafkaStreamsBinderMetrics {
    static final String DEFAULT_VALUE = "unknown";
    static final String CLIENT_ID_TAG_NAME = "client-id";
    static final String METRIC_GROUP_APP_INFO = "app-info";
    static final String VERSION_METRIC_NAME = "version";
    static final String START_TIME_METRIC_NAME = "start-time-ms";
    static final String KAFKA_VERSION_TAG_NAME = "kafka-version";
    static final String METRIC_NAME_PREFIX = "kafka.";
    static final String METRIC_GROUP_METRICS_COUNT = "kafka-metrics-count";
    private String kafkaVersion = "unknown";
    private String clientId = "unknown";
    private final MeterRegistry meterRegistry;
    private MeterBinder meterBinder;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private volatile Set<MetricName> currentMeters = new HashSet<MetricName>();

    public KafkaStreamsBinderMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void bindTo(Set<StreamsBuilderFactoryBean> streamsBuilderFactoryBeans) {
        if (this.meterBinder == null) {
            this.meterBinder = registry -> {
                if (streamsBuilderFactoryBeans != null) {
                    for (StreamsBuilderFactoryBean streamsBuilderFactoryBean : streamsBuilderFactoryBeans) {
                        if (!streamsBuilderFactoryBean.isRunning()) continue;
                        KafkaStreams kafkaStreams = streamsBuilderFactoryBean.getKafkaStreams();
                        Map metrics = kafkaStreams.metrics();
                        this.prepareToBindMetrics(registry, metrics);
                        this.checkAndBindMetrics(registry, metrics);
                    }
                }
            };
        }
        this.meterBinder.bindTo(this.meterRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetrics(Set<StreamsBuilderFactoryBean> streamsBuilderFactoryBeans) {
        KafkaStreamsBinderMetrics kafkaStreamsBinderMetrics = this;
        synchronized (kafkaStreamsBinderMetrics) {
            this.bindTo(streamsBuilderFactoryBeans);
        }
    }

    void prepareToBindMetrics(MeterRegistry registry, Map<MetricName, ? extends Metric> metrics) {
        Metric startTime = null;
        for (Map.Entry<MetricName, ? extends Metric> entry : metrics.entrySet()) {
            MetricName name = entry.getKey();
            if (this.clientId.equals(DEFAULT_VALUE) && name.tags().get(CLIENT_ID_TAG_NAME) != null) {
                this.clientId = (String)name.tags().get(CLIENT_ID_TAG_NAME);
            }
            if (!METRIC_GROUP_APP_INFO.equals(name.group())) continue;
            if (VERSION_METRIC_NAME.equals(name.name())) {
                this.kafkaVersion = (String)entry.getValue().metricValue();
                continue;
            }
            if (!START_TIME_METRIC_NAME.equals(name.name())) continue;
            startTime = entry.getValue();
        }
        if (startTime != null) {
            this.bindMeter(registry, startTime, this.meterName(startTime), this.meterTags(startTime));
        }
    }

    private void bindMeter(MeterRegistry registry, Metric metric, String name, Iterable<Tag> tags) {
        if (name.endsWith("total") || name.endsWith("count")) {
            this.registerCounter(registry, metric, name, tags);
        } else {
            this.registerGauge(registry, metric, name, tags);
        }
    }

    private void registerCounter(MeterRegistry registry, Metric metric, String name, Iterable<Tag> tags) {
        FunctionCounter.builder((String)name, (Object)metric, this.toMetricValue()).tags(tags).description(metric.metricName().description()).register(registry);
    }

    private ToDoubleFunction<Metric> toMetricValue() {
        return metric -> ((Number)metric.metricValue()).doubleValue();
    }

    private void registerGauge(MeterRegistry registry, Metric metric, String name, Iterable<Tag> tags) {
        Gauge.builder((String)name, (Object)metric, this.toMetricValue()).tags(tags).description(metric.metricName().description()).register(registry);
    }

    private List<Tag> meterTags(Metric metric) {
        return this.meterTags(metric, false);
    }

    private String meterName(Metric metric) {
        String name = METRIC_NAME_PREFIX + metric.metricName().group() + "." + metric.metricName().name();
        return name.replaceAll("-metrics", "").replaceAll("-", ".");
    }

    private List<Tag> meterTags(Metric metric, boolean includeCommonTags) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        metric.metricName().tags().forEach((key, value) -> tags.add(Tag.of((String)key, (String)value)));
        tags.add(Tag.of((String)KAFKA_VERSION_TAG_NAME, (String)this.kafkaVersion));
        return tags;
    }

    private boolean differentClient(List<Tag> tags) {
        for (Tag tag : tags) {
            if (!tag.getKey().equals(CLIENT_ID_TAG_NAME) || this.clientId.equals(tag.getValue())) continue;
            return true;
        }
        return false;
    }

    void checkAndBindMetrics(MeterRegistry registry, Map<MetricName, ? extends Metric> metrics) {
        if (!this.currentMeters.equals(metrics.keySet())) {
            this.currentMeters = new HashSet<MetricName>(metrics.keySet());
            metrics.forEach((name, metric) -> {
                Meter other;
                List tags;
                if (!(metric.metricValue() instanceof Number)) {
                    return;
                }
                if (METRIC_GROUP_APP_INFO.equals(name.group())) {
                    return;
                }
                if (METRIC_GROUP_METRICS_COUNT.equals(name.group())) {
                    return;
                }
                String meterName = this.meterName((Metric)metric);
                List<Tag> meterTagsWithCommonTags = this.meterTags((Metric)metric, true);
                boolean hasLessTags = false;
                Iterator iterator = registry.find(meterName).meters().iterator();
                while (iterator.hasNext() && !this.differentClient(tags = (other = (Meter)iterator.next()).getId().getTags())) {
                    if (tags.size() < meterTagsWithCommonTags.size()) {
                        registry.remove(other);
                        continue;
                    }
                    if (tags.size() == meterTagsWithCommonTags.size()) {
                        if (!tags.equals(meterTagsWithCommonTags)) break;
                        return;
                    }
                    hasLessTags = true;
                }
                if (hasLessTags) {
                    return;
                }
                this.bindMeter(registry, (Metric)metric, meterName, (Iterable<Tag>)this.meterTags((Metric)metric));
            });
        }
    }
}

