/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.integration.channel.AbstractSubscribableChannel;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class AbstractTestBinder<C extends AbstractBinder<MessageChannel, CP, PP>, CP extends ConsumerProperties, PP extends ProducerProperties>
implements Binder<MessageChannel, CP, PP> {
    protected Set<String> queues = new HashSet<String>();
    private C binder;

    public Binding<MessageChannel> bindConsumer(String name, String group, MessageChannel moduleInputChannel, CP properties) {
        this.checkChannelIsConfigured(moduleInputChannel, properties);
        this.queues.add(name);
        return this.binder.bindConsumer(name, group, (Object)moduleInputChannel, properties);
    }

    public Binding<MessageChannel> bindProducer(String name, MessageChannel moduleOutputChannel, PP properties) {
        this.queues.add(name);
        return this.binder.bindProducer(name, (Object)moduleOutputChannel, properties);
    }

    public C getCoreBinder() {
        return this.binder;
    }

    public abstract void cleanup();

    public C getBinder() {
        return this.binder;
    }

    public void setBinder(C binder) {
        try {
            binder.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize binder", e);
        }
        this.binder = binder;
    }

    private void checkChannelIsConfigured(MessageChannel messageChannel, CP properties) {
        if (messageChannel instanceof AbstractSubscribableChannel && !properties.isUseNativeDecoding()) {
            Assert.isTrue((!CollectionUtils.isEmpty((Collection)((AbstractSubscribableChannel)messageChannel).getChannelInterceptors()) ? 1 : 0) != 0, (String)"'messageChannel' appears to be misconfigured. Consider creating channel via AbstractBinderTest.createBindableChannel(..)");
        }
    }
}

