/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.metrics;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.actuate.metrics.export.MetricExportProperties;
import org.springframework.boot.actuate.metrics.export.TriggerProperties;
import org.springframework.boot.bind.RelaxedNames;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.metrics.RelaxedPropertiesUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;

@ConfigurationProperties(prefix="spring.cloud.stream.metrics")
public class ApplicationMetricsProperties
implements ApplicationListener<ContextRefreshedEvent> {
    private final MetricExportProperties metricExportProperties;
    private String prefix = "";
    @Value(value="${spring.application.name:${vcap.application.name:${spring.config.name:application}}}")
    private String key;
    private String metricName;
    private String[] properties;
    private Map<String, Object> exportProperties = new HashMap<String, Object>();

    public ApplicationMetricsProperties(MetricExportProperties metricExportProperties) {
        Assert.notNull((Object)metricExportProperties, (String)"'metricsExportProperties' cannot be null");
        this.metricExportProperties = metricExportProperties;
    }

    public TriggerProperties getTrigger() {
        return this.metricExportProperties.findTrigger("application");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        this.prefix = prefix;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public void setProperties(String[] properties) {
        this.properties = properties;
    }

    public Map<String, Object> getExportProperties() {
        return this.exportProperties;
    }

    public String getMetricName() {
        if (this.metricName == null) {
            this.metricName = this.resolveMetricName();
        }
        return this.metricName;
    }

    private String resolveMetricName() {
        return this.prefix + this.key;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.exportProperties.clear();
        ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)event.getSource();
        ConfigurableEnvironment environment = ctx.getEnvironment();
        BeanExpressionResolver beanExpressionResolver = ctx.getBeanFactory().getBeanExpressionResolver();
        BeanExpressionContext expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)ctx.getBeanFactory(), null);
        if (!ObjectUtils.isEmpty((Object[])this.properties)) {
            for (PropertySource source : environment.getPropertySources()) {
                if (!(source instanceof EnumerablePropertySource)) continue;
                EnumerablePropertySource e = (EnumerablePropertySource)source;
                block1: for (String propertyName : e.getPropertyNames()) {
                    RelaxedNames relaxedNames = new RelaxedNames(propertyName);
                    String canonicalFormat = RelaxedPropertiesUtils.findCanonicalFormat((Iterable<String>)relaxedNames);
                    if (this.exportProperties.containsKey(canonicalFormat)) continue;
                    for (String relaxedPropertyName : relaxedNames) {
                        if (!this.isMatch(relaxedPropertyName, this.properties, null)) continue;
                        Object value = source.getProperty(propertyName);
                        String stringValue = ObjectUtils.nullSafeToString((Object)value);
                        String exportedValue = null;
                        if (value != null) {
                            exportedValue = stringValue.startsWith("#{") ? beanExpressionResolver.evaluate(environment.resolvePlaceholders(stringValue), expressionContext) : environment.resolvePlaceholders(stringValue);
                        }
                        this.exportProperties.put(canonicalFormat, exportedValue);
                        continue block1;
                    }
                }
            }
        }
    }

    private boolean isMatch(String name, String[] includes, String[] excludes) {
        if (ObjectUtils.isEmpty((Object[])includes) || PatternMatchUtils.simpleMatch((String[])includes, (String)name)) {
            return !PatternMatchUtils.simpleMatch((String[])excludes, (String)name);
        }
        return false;
    }
}

