/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.test;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.binder.test.AbstractDestination;
import org.springframework.integration.channel.AbstractSubscribableChannel;
import org.springframework.messaging.Message;
import org.springframework.util.StringUtils;

public class OutputDestination
extends AbstractDestination {
    private final Log log = LogFactory.getLog(OutputDestination.class);
    private final ConcurrentHashMap<String, BlockingQueue<Message<byte[]>>> messageQueues = new ConcurrentHashMap();

    public Message<byte[]> receive(long timeout, String bindingName) {
        try {
            bindingName = ((String)bindingName).endsWith(".destination") ? bindingName : (String)bindingName + ".destination";
            return this.outputQueue((String)bindingName).poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public void clear() {
        this.messageQueues.values().forEach(v -> v.clear());
    }

    public boolean clear(String destinationName) {
        Object queueName;
        Object object = queueName = destinationName.endsWith(".destination") ? destinationName : destinationName + ".destination";
        if (StringUtils.hasText((String)destinationName) && this.messageQueues.containsKey(queueName)) {
            this.messageQueues.get(queueName).clear();
            return true;
        }
        return false;
    }

    public Message<byte[]> receive() {
        return this.receive(0L, 0);
    }

    public Message<byte[]> receive(long timeout) {
        return this.receive(timeout, 0);
    }

    @Override
    void afterChannelIsSet(int channelIndex, String bindingName) {
        if (((AbstractSubscribableChannel)this.getChannelByName(bindingName)).getSubscriberCount() < 1) {
            this.getChannelByName(bindingName).subscribe(message -> this.outputQueue(bindingName).offer((Message<byte[]>)message));
        }
    }

    private BlockingQueue<Message<byte[]>> outputQueue(String bindingName) {
        this.messageQueues.putIfAbsent(bindingName, new LinkedTransferQueue());
        return this.messageQueues.get(bindingName);
    }

    private Message<byte[]> receive(long timeout, int bindingIndex) {
        this.log.warn((Object)"!!!While 'receive(long timeout, int bindingIndex)' method may still work it is deprecated no longer supported. It will be removed after 3.1.3 release. Please use 'receive(long timeout, String bindingName)'");
        try {
            BlockingQueue<Message<byte[]>> destinationQueue = new ArrayList<BlockingQueue<Message<byte[]>>>(this.messageQueues.values()).get(bindingIndex);
            return destinationQueue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }
}

