/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import org.springframework.cloud.stream.binder.Binding;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.util.Assert;

public class DefaultBinding<T>
implements Binding<T> {
    private final String name;
    private final String group;
    private final T target;
    private final AbstractEndpoint endpoint;

    public DefaultBinding(String name, String group, T target, AbstractEndpoint endpoint) {
        Assert.notNull(target, (String)"target must not be null");
        Assert.notNull((Object)endpoint, (String)"endpoint must not be null");
        this.name = name;
        this.group = group;
        this.target = target;
        this.endpoint = endpoint;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public final void unbind() {
        this.endpoint.stop();
        this.afterUnbind();
    }

    protected void afterUnbind() {
    }

    public String toString() {
        return " Binding [name=" + this.name + ", target=" + this.target + ", endpoint=" + this.endpoint.getComponentName() + "]";
    }
}

