/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.cloud.stream.annotation.Bindings;
import org.springframework.cloud.stream.annotation.Input;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.cloud.stream.binding.BindableProxyFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class BindingBeanDefinitionRegistryUtils {
    public static void registerInputChannelBeanDefinition(String qualifierValue, String name, String channelInterfaceBeanName, String channelInterfaceMethodName, BeanDefinitionRegistry registry) {
        BindingBeanDefinitionRegistryUtils.registerChannelBeanDefinition(Input.class, qualifierValue, name, channelInterfaceBeanName, channelInterfaceMethodName, registry);
    }

    public static void registerOutputChannelBeanDefinition(String qualifierValue, String name, String channelInterfaceBeanName, String channelInterfaceMethodName, BeanDefinitionRegistry registry) {
        BindingBeanDefinitionRegistryUtils.registerChannelBeanDefinition(Output.class, qualifierValue, name, channelInterfaceBeanName, channelInterfaceMethodName, registry);
    }

    private static void registerChannelBeanDefinition(Class<? extends Annotation> qualifier, String qualifierValue, String name, String channelInterfaceBeanName, String channelInterfaceMethodName, BeanDefinitionRegistry registry) {
        RootBeanDefinition rootBeanDefinition = new RootBeanDefinition();
        rootBeanDefinition.setFactoryBeanName(channelInterfaceBeanName);
        rootBeanDefinition.setUniqueFactoryMethodName(channelInterfaceMethodName);
        rootBeanDefinition.addQualifier(new AutowireCandidateQualifier(qualifier, (Object)qualifierValue));
        registry.registerBeanDefinition(name, (BeanDefinition)rootBeanDefinition);
    }

    public static void registerChannelBeanDefinitions(Class<?> type, final String channelInterfaceBeanName, final BeanDefinitionRegistry registry) {
        ReflectionUtils.doWithMethods(type, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Output output;
                Input input = (Input)AnnotationUtils.findAnnotation((Method)method, Input.class);
                if (input != null) {
                    String name = BindingBeanDefinitionRegistryUtils.getChannelName(input, method);
                    BindingBeanDefinitionRegistryUtils.registerInputChannelBeanDefinition(input.value(), name, channelInterfaceBeanName, method.getName(), registry);
                }
                if ((output = (Output)AnnotationUtils.findAnnotation((Method)method, Output.class)) != null) {
                    String name = BindingBeanDefinitionRegistryUtils.getChannelName(output, method);
                    BindingBeanDefinitionRegistryUtils.registerOutputChannelBeanDefinition(output.value(), name, channelInterfaceBeanName, method.getName(), registry);
                }
            }
        });
    }

    public static void registerChannelsQualifiedBeanDefinitions(Class<?> parent, Class<?> type, BeanDefinitionRegistry registry) {
        if (type.isInterface()) {
            RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(BindableProxyFactory.class);
            rootBeanDefinition.addQualifier(new AutowireCandidateQualifier(Bindings.class, parent));
            rootBeanDefinition.getConstructorArgumentValues().addGenericArgumentValue(type);
            registry.registerBeanDefinition(type.getName(), (BeanDefinition)rootBeanDefinition);
        } else {
            RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(type);
            rootBeanDefinition.addQualifier(new AutowireCandidateQualifier(Bindings.class, parent));
            registry.registerBeanDefinition(type.getName(), (BeanDefinition)rootBeanDefinition);
        }
    }

    public static String getChannelName(Annotation annotation, Method method) {
        Map attrs = AnnotationUtils.getAnnotationAttributes((Annotation)annotation, (boolean)false);
        if (attrs.containsKey("value") && StringUtils.hasText((CharSequence)((CharSequence)attrs.get("value")))) {
            return (String)attrs.get("value");
        }
        return method.getName();
    }
}

