/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binding.BindableAdapter;
import org.springframework.cloud.stream.binding.ChannelBindingService;

public final class DynamicDestinationsBindable
extends BindableAdapter {
    private Map<String, Binding> outputBindings = new HashMap<String, Binding>();

    public void addOutputBinding(String name, Binding binding) {
        this.outputBindings.put(name, binding);
    }

    @Override
    public Set<String> getOutputs() {
        return Collections.unmodifiableSet(this.outputBindings.keySet());
    }

    @Override
    public void unbindOutputs(ChannelBindingService adapter) {
        for (Map.Entry<String, Binding> entry : this.outputBindings.entrySet()) {
            entry.getValue().unbind();
        }
        this.outputBindings.clear();
    }
}

