/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.springframework.cloud.stream.binder.MessageValues;
import org.springframework.integration.support.json.Jackson2JsonObjectMapper;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public class EmbeddedHeadersMessageConverter {
    private final Jackson2JsonObjectMapper objectMapper = new Jackson2JsonObjectMapper();

    public static String decodeExceptionMessage(Message<?> requestMessage) {
        return "Could not convert message: " + DatatypeConverter.printHexBinary((byte[])((byte[])requestMessage.getPayload()));
    }

    public byte[] embedHeaders(MessageValues original, String ... headers) throws Exception {
        byte[][] headerValues = new byte[headers.length][];
        int n = 0;
        int headerCount = 0;
        int headersLength = 0;
        for (String header : headers) {
            Object value;
            Object object = value = original.get(header) == null ? null : original.get(header);
            if (value != null) {
                String json = this.objectMapper.toJson(value);
                headerValues[n] = json.getBytes("UTF-8");
                ++headerCount;
                headersLength += header.length() + headerValues[n++].length;
                continue;
            }
            headerValues[n++] = null;
        }
        byte[] newPayload = new byte[((byte[])original.getPayload()).length + headersLength + headerCount * 5 + 2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(newPayload);
        byteBuffer.put((byte)-1);
        byteBuffer.put((byte)headerCount);
        for (int i = 0; i < headers.length; ++i) {
            if (headerValues[i] == null) continue;
            byteBuffer.put((byte)headers[i].length());
            byteBuffer.put(headers[i].getBytes("UTF-8"));
            byteBuffer.putInt(headerValues[i].length);
            byteBuffer.put(headerValues[i]);
        }
        byteBuffer.put((byte[])original.getPayload());
        return byteBuffer.array();
    }

    public MessageValues extractHeaders(Message<byte[]> message, boolean copyRequestHeaders) throws Exception {
        return this.extractHeaders((byte[])message.getPayload(), copyRequestHeaders, message.getHeaders());
    }

    private MessageValues extractHeaders(byte[] payload, boolean copyRequestHeaders, MessageHeaders requestHeaders) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload);
        int headerCount = byteBuffer.get() & 0xFF;
        if (headerCount < 255) {
            return this.oldExtractHeaders(byteBuffer, payload, headerCount, copyRequestHeaders, requestHeaders);
        }
        headerCount = byteBuffer.get() & 0xFF;
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (int i = 0; i < headerCount; ++i) {
            int len = byteBuffer.get() & 0xFF;
            String headerName = new String(payload, byteBuffer.position(), len, "UTF-8");
            byteBuffer.position(byteBuffer.position() + len);
            len = byteBuffer.getInt();
            String headerValue = new String(payload, byteBuffer.position(), len, "UTF-8");
            Object headerContent = this.objectMapper.fromJson((Object)headerValue, Object.class);
            headers.put(headerName, headerContent);
            byteBuffer.position(byteBuffer.position() + len);
        }
        byte[] newPayload = new byte[byteBuffer.remaining()];
        byteBuffer.get(newPayload);
        return this.buildMessageValues(newPayload, headers, copyRequestHeaders, requestHeaders);
    }

    public MessageValues extractHeaders(byte[] payload) throws Exception {
        return this.extractHeaders(payload, false, null);
    }

    private MessageValues oldExtractHeaders(ByteBuffer byteBuffer, byte[] bytes, int headerCount, boolean copyRequestHeaders, MessageHeaders requestHeaders) throws UnsupportedEncodingException {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (int i = 0; i < headerCount; ++i) {
            int len = byteBuffer.get();
            String headerName = new String(bytes, byteBuffer.position(), len, "UTF-8");
            byteBuffer.position(byteBuffer.position() + len);
            len = byteBuffer.get() & 0xFF;
            String headerValue = new String(bytes, byteBuffer.position(), len, "UTF-8");
            byteBuffer.position(byteBuffer.position() + len);
            if ("sequenceNumber".equals(headerName) || "sequenceSize".equals(headerName)) {
                headers.put(headerName, Integer.parseInt(headerValue));
                continue;
            }
            headers.put(headerName, headerValue);
        }
        byte[] newPayload = new byte[byteBuffer.remaining()];
        byteBuffer.get(newPayload);
        return this.buildMessageValues(newPayload, headers, copyRequestHeaders, requestHeaders);
    }

    private MessageValues buildMessageValues(byte[] payload, Map<String, Object> headers, boolean copyRequestHeaders, MessageHeaders requestHeaders) {
        MessageValues messageValues = new MessageValues(payload, headers);
        if (copyRequestHeaders && requestHeaders != null) {
            messageValues.copyHeadersIfAbsent((Map<String, Object>)requestHeaders);
        }
        return messageValues;
    }
}

