/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.stream.annotation.Input;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.cloud.stream.binding.MessageChannelStreamListenerResultAdapter;
import org.springframework.cloud.stream.binding.StreamListenerMethodUtils;
import org.springframework.cloud.stream.binding.StreamListenerParameterAdapter;
import org.springframework.cloud.stream.binding.StreamListenerResultAdapter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class StreamListenerAnnotationBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
SmartInitializingSingleton {
    private final DestinationResolver<MessageChannel> binderAwareChannelResolver;
    private final MessageHandlerMethodFactory messageHandlerMethodFactory;
    private final Map<String, InvocableHandlerMethod> mappedBindings = new HashMap<String, InvocableHandlerMethod>();
    private ConfigurableApplicationContext applicationContext;
    private final List<StreamListenerParameterAdapter<?, Object>> streamListenerParameterAdapters = new ArrayList();
    private final List<StreamListenerResultAdapter<?, ?>> streamListenerResultAdapters = new ArrayList();

    public StreamListenerAnnotationBeanPostProcessor(DestinationResolver<MessageChannel> binderAwareChannelResolver, MessageHandlerMethodFactory messageHandlerMethodFactory) {
        Assert.notNull(binderAwareChannelResolver, (String)"Destination resolver cannot be null");
        Assert.notNull((Object)messageHandlerMethodFactory, (String)"Message handler method factory cannot be null");
        this.binderAwareChannelResolver = binderAwareChannelResolver;
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        Map parameterAdapterMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, StreamListenerParameterAdapter.class);
        for (StreamListenerParameterAdapter parameterAdapter : parameterAdapterMap.values()) {
            this.streamListenerParameterAdapters.add(parameterAdapter);
        }
        Map resultAdapterMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, StreamListenerResultAdapter.class);
        this.streamListenerResultAdapters.add(new MessageChannelStreamListenerResultAdapter());
        for (StreamListenerResultAdapter resultAdapter : resultAdapterMap.values()) {
            this.streamListenerResultAdapters.add(resultAdapter);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, String beanName) throws BeansException {
        Class<?> targetClass = AopUtils.isAopProxy((Object)bean) ? AopUtils.getTargetClass((Object)bean) : bean.getClass();
        ReflectionUtils.doWithMethods(targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                StreamListener streamListener = (StreamListener)AnnotationUtils.findAnnotation((Method)method, StreamListener.class);
                if (streamListener != null && !method.isBridge()) {
                    Assert.isTrue((method.getAnnotation(Input.class) == null ? 1 : 0) != 0, (String)"A method annotated with @StreamListener may never be annotated with @Input. If it should listen to a specific input, use the value of @StreamListener instead");
                    String methodAnnotatedInboundName = streamListener.value();
                    String methodAnnotatedOutboundName = StreamListenerMethodUtils.getOutboundBindingTargetName(method);
                    int inputAnnotationCount = StreamListenerMethodUtils.inputAnnotationCount(method);
                    int outputAnnotationCount = StreamListenerMethodUtils.outputAnnotationCount(method);
                    boolean isDeclarative = StreamListenerAnnotationBeanPostProcessor.this.checkDeclarativeMethod(method, methodAnnotatedInboundName, methodAnnotatedOutboundName);
                    StreamListenerMethodUtils.validateStreamListenerMethod(method, inputAnnotationCount, outputAnnotationCount, methodAnnotatedInboundName, methodAnnotatedOutboundName, isDeclarative);
                    if (!method.getReturnType().equals(Void.TYPE) && !StringUtils.hasText((String)methodAnnotatedOutboundName)) {
                        if (outputAnnotationCount == 0) {
                            throw new IllegalArgumentException("A method annotated with @StreamListener having a return type should also have an outbound target specified");
                        }
                        Assert.isTrue((outputAnnotationCount == 1 ? 1 : 0) != 0, (String)"A method annotated with @StreamListener having a return type should have only one outbound target specified");
                    }
                    if (isDeclarative) {
                        StreamListenerAnnotationBeanPostProcessor.this.invokeSetupMethodOnListenedChannel(method, bean, methodAnnotatedInboundName, methodAnnotatedOutboundName);
                    } else {
                        StreamListenerAnnotationBeanPostProcessor.this.registerHandlerMethodOnListenedChannel(method, streamListener, bean);
                    }
                }
            }
        });
        return bean;
    }

    private boolean checkDeclarativeMethod(Method method, String methodAnnotatedInboundName, String methodAnnotatedOutboundName) {
        int methodArgumentsLength = method.getParameterTypes().length;
        for (int parameterIndex = 0; parameterIndex < methodArgumentsLength; ++parameterIndex) {
            MethodParameter methodParameter = MethodParameter.forMethodOrConstructor((Object)method, (int)parameterIndex);
            if (methodParameter.hasParameterAnnotation(Input.class)) {
                String inboundName = (String)AnnotationUtils.getValue((Annotation)methodParameter.getParameterAnnotation(Input.class));
                Assert.isTrue((boolean)StringUtils.hasText((String)inboundName), (String)"The @Input annotation must have the name of an input as value");
                Assert.isTrue((boolean)this.isDeclarativeMethodParameter(this.applicationContext.getBean(inboundName), methodParameter), (String)"A method annotated with @StreamListener may use @Input or @Output annotations only in declarative mode and for parameters that are binding targets or convertible from binding targets.");
                return true;
            }
            if (methodParameter.hasParameterAnnotation(Output.class)) {
                String outboundName = (String)AnnotationUtils.getValue((Annotation)methodParameter.getParameterAnnotation(Output.class));
                Assert.isTrue((boolean)StringUtils.hasText((String)outboundName), (String)"The @Output annotation must have the name of an input as value");
                Assert.isTrue((boolean)this.isDeclarativeMethodParameter(this.applicationContext.getBean(outboundName), methodParameter), (String)"A method annotated with @StreamListener may use @Input or @Output annotations only in declarative mode and for parameters that are binding targets or convertible from binding targets.");
                return true;
            }
            if (StringUtils.hasText((String)methodAnnotatedOutboundName)) {
                return this.isDeclarativeMethodParameter(this.applicationContext.getBean(methodAnnotatedOutboundName), methodParameter);
            }
            if (!StringUtils.hasText((String)methodAnnotatedInboundName)) continue;
            return this.isDeclarativeMethodParameter(this.applicationContext.getBean(methodAnnotatedInboundName), methodParameter);
        }
        return false;
    }

    private boolean isDeclarativeMethodParameter(Object targetBean, MethodParameter methodParameter) {
        if (targetBean != null) {
            if (methodParameter.getParameterType().isAssignableFrom(targetBean.getClass())) {
                return true;
            }
            for (StreamListenerParameterAdapter<?, Object> streamListenerParameterAdapter : this.streamListenerParameterAdapters) {
                if (!streamListenerParameterAdapter.supports(targetBean.getClass(), methodParameter)) continue;
                return true;
            }
        }
        return false;
    }

    private void invokeSetupMethodOnListenedChannel(Method method, Object bean, String inboundName, String outboundName) {
        block17: {
            Object[] arguments = new Object[method.getParameterTypes().length];
            for (int parameterIndex = 0; parameterIndex < arguments.length; ++parameterIndex) {
                Object targetBean;
                MethodParameter methodParameter = MethodParameter.forMethodOrConstructor((Object)method, (int)parameterIndex);
                Class parameterType = methodParameter.getParameterType();
                Object targetReferenceValue = null;
                if (methodParameter.hasParameterAnnotation(Input.class)) {
                    targetReferenceValue = AnnotationUtils.getValue((Annotation)methodParameter.getParameterAnnotation(Input.class));
                } else if (methodParameter.hasParameterAnnotation(Output.class)) {
                    targetReferenceValue = AnnotationUtils.getValue((Annotation)methodParameter.getParameterAnnotation(Output.class));
                } else if (arguments.length == 1 && StringUtils.hasText((String)inboundName)) {
                    targetReferenceValue = inboundName;
                }
                if (targetReferenceValue != null) {
                    Assert.isInstanceOf(String.class, (Object)targetReferenceValue, (String)"Annotation value must be a String");
                    targetBean = this.applicationContext.getBean((String)targetReferenceValue);
                    if (parameterType.isAssignableFrom(targetBean.getClass())) {
                        arguments[parameterIndex] = targetBean;
                    } else {
                        for (StreamListenerParameterAdapter<?, Object> streamListenerParameterAdapter : this.streamListenerParameterAdapters) {
                            if (!streamListenerParameterAdapter.supports(targetBean.getClass(), methodParameter)) continue;
                            arguments[parameterIndex] = streamListenerParameterAdapter.adapt(targetBean, methodParameter);
                            break;
                        }
                    }
                } else {
                    throw new IllegalStateException("A method annotated with @StreamListener may use @Input or @Output annotations only in declarative mode and for parameters that are binding targets or convertible from binding targets.");
                }
                Assert.notNull((Object)arguments[parameterIndex], (String)("Cannot convert argument " + parameterIndex + " of " + method + "from " + targetBean.getClass() + " to " + parameterType));
            }
            try {
                if (method.getReturnType().equals(Void.TYPE)) {
                    method.invoke(bean, arguments);
                    break block17;
                }
                Object result = method.invoke(bean, arguments);
                if (!StringUtils.hasText((String)outboundName)) {
                    for (int parameterIndex = 0; parameterIndex < method.getParameterTypes().length; ++parameterIndex) {
                        MethodParameter methodParameter = MethodParameter.forMethodOrConstructor((Object)method, (int)parameterIndex);
                        if (!methodParameter.hasParameterAnnotation(Output.class)) continue;
                        outboundName = ((Output)methodParameter.getParameterAnnotation(Output.class)).value();
                    }
                }
                Object targetBean = this.applicationContext.getBean(outboundName);
                for (StreamListenerResultAdapter<?, ?> streamListenerResultAdapter : this.streamListenerResultAdapters) {
                    if (!streamListenerResultAdapter.supports(result.getClass(), targetBean.getClass())) continue;
                    streamListenerResultAdapter.adapt(result, targetBean);
                    break;
                }
            }
            catch (Exception e) {
                throw new BeanInitializationException("Cannot setup StreamListener for " + method, (Throwable)e);
            }
        }
    }

    protected void registerHandlerMethodOnListenedChannel(Method method, StreamListener streamListener, Object bean) {
        Method targetMethod = this.checkProxy(method, bean);
        Assert.hasText((String)streamListener.value(), (String)"The binding name cannot be null");
        InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(bean, targetMethod);
        if (!StringUtils.hasText((String)streamListener.value())) {
            throw new BeanInitializationException("A bound component name must be specified");
        }
        if (this.mappedBindings.containsKey(streamListener.value())) {
            throw new BeanInitializationException("Duplicate @" + StreamListener.class.getSimpleName() + " mapping for '" + streamListener.value() + "' on " + invocableHandlerMethod.getShortLogMessage() + " already existing for " + this.mappedBindings.get(streamListener.value()).getShortLogMessage());
        }
        this.mappedBindings.put(streamListener.value(), invocableHandlerMethod);
        SubscribableChannel channel = (SubscribableChannel)this.applicationContext.getBean(streamListener.value(), SubscribableChannel.class);
        String defaultOutputChannel = StreamListenerMethodUtils.getOutboundBindingTargetName(method);
        if (invocableHandlerMethod.isVoid()) {
            Assert.isTrue((boolean)StringUtils.isEmpty((Object)defaultOutputChannel), (String)"An output channel cannot be specified for a method that does not return a value");
        } else {
            Assert.isTrue((!StringUtils.isEmpty((Object)defaultOutputChannel) ? 1 : 0) != 0, (String)"An output channel must be specified for a method that can return a value");
        }
        StreamListenerMethodUtils.validateStreamListenerMessageHandler(method);
        StreamListenerMessageHandler handler = new StreamListenerMessageHandler(invocableHandlerMethod);
        handler.setApplicationContext((ApplicationContext)this.applicationContext);
        handler.setChannelResolver(this.binderAwareChannelResolver);
        if (!StringUtils.isEmpty((Object)defaultOutputChannel)) {
            handler.setOutputChannelName(defaultOutputChannel);
        }
        handler.afterPropertiesSet();
        channel.subscribe((MessageHandler)handler);
    }

    public void afterSingletonsInstantiated() {
        this.mappedBindings.clear();
    }

    private Method checkProxy(Method methodArg, Object bean) {
        Method method = methodArg;
        if (AopUtils.isJdkDynamicProxy((Object)bean)) {
            try {
                Class[] proxiedInterfaces;
                method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                for (Class iface : proxiedInterfaces = ((Advised)bean).getProxiedInterfaces()) {
                    try {
                        method = iface.getMethod(method.getName(), method.getParameterTypes());
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            catch (SecurityException ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(String.format("@StreamListener method '%s' found on bean target class '%s', but not found in any interface(s) for bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()), ex);
            }
        }
        return method;
    }

    private final class StreamListenerMessageHandler
    extends AbstractReplyProducingMessageHandler {
        private final InvocableHandlerMethod invocableHandlerMethod;

        private StreamListenerMessageHandler(InvocableHandlerMethod invocableHandlerMethod) {
            this.invocableHandlerMethod = invocableHandlerMethod;
        }

        protected boolean shouldCopyRequestHeaders() {
            return false;
        }

        protected Object handleRequestMessage(Message<?> requestMessage) {
            try {
                return this.invocableHandlerMethod.invoke(requestMessage, new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof MessagingException) {
                    throw (MessagingException)e;
                }
                throw new MessagingException(requestMessage, "Exception thrown while invoking " + this.invocableHandlerMethod.getShortLogMessage(), (Throwable)e);
            }
        }
    }
}

