/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import java.nio.charset.Charset;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.MimeType;

public class ObjectStringMessageConverter
extends AbstractMessageConverter {
    public ObjectStringMessageConverter() {
        super(new MimeType("text", "plain", Charset.forName("UTF-8")));
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        if (message.getPayload() != null) {
            if (message.getPayload() instanceof byte[]) {
                return new String((byte[])message.getPayload(), Charset.forName("UTF-8"));
            }
            return message.getPayload().toString();
        }
        return null;
    }

    protected Object convertToInternal(Object payload, MessageHeaders headers, Object conversionHint) {
        if (payload != null) {
            return payload.toString();
        }
        return null;
    }
}

