/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.aggregate;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.integration.monitor.IntegrationMBeanExporter;
import org.springframework.integration.support.management.Statistics;
import org.springframework.util.Assert;

public class NamespaceAwareSpringIntegrationMetricReader
implements MetricReader {
    private final String namespace;
    private final IntegrationMBeanExporter exporter;

    public NamespaceAwareSpringIntegrationMetricReader(String namespace, IntegrationMBeanExporter exporter) {
        Assert.hasText((String)namespace, (String)"cannot be null or empty String");
        Assert.notNull((Object)exporter, (String)"cannot be null");
        this.namespace = namespace;
        this.exporter = exporter;
    }

    public Metric<?> findOne(String metricName) {
        return null;
    }

    public Iterable<Metric<?>> findAll() {
        IntegrationMBeanExporter exporter = this.exporter;
        ArrayList metrics = new ArrayList();
        for (String name : exporter.getChannelNames()) {
            String prefix = "integration.channel." + this.namespace + "." + name;
            metrics.addAll(this.getStatistics(prefix + ".errorRate", exporter.getChannelErrorRate(name)));
            metrics.add(new Metric(prefix + ".sendCount", (Number)exporter.getChannelSendCountLong(name)));
            metrics.addAll(this.getStatistics(prefix + ".sendRate", exporter.getChannelSendRate(name)));
            metrics.add(new Metric(prefix + ".receiveCount", (Number)exporter.getChannelReceiveCountLong(name)));
        }
        for (String name : exporter.getHandlerNames()) {
            metrics.addAll(this.getStatistics("integration." + this.namespace + ".handler." + name + ".duration", exporter.getHandlerDuration(name)));
        }
        metrics.add(new Metric("integration." + this.namespace + ".activeHandlerCount", (Number)exporter.getActiveHandlerCount()));
        metrics.add(new Metric("integration." + this.namespace + ".handlerCount", (Number)exporter.getHandlerCount()));
        metrics.add(new Metric("integration." + this.namespace + ".channelCount", (Number)exporter.getChannelCount()));
        metrics.add(new Metric("integration." + this.namespace + ".queuedMessageCount", (Number)exporter.getQueuedMessageCount()));
        return metrics;
    }

    private Collection<? extends Metric<?>> getStatistics(String name, Statistics statistic) {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        metrics.add(new Metric(name + ".mean", (Number)statistic.getMean()));
        metrics.add(new Metric(name + ".max", (Number)statistic.getMax()));
        metrics.add(new Metric(name + ".min", (Number)statistic.getMin()));
        metrics.add(new Metric(name + ".stdev", (Number)statistic.getStandardDeviation()));
        metrics.add(new Metric(name + ".count", (Number)statistic.getCountLong()));
        return metrics;
    }

    public long count() {
        int totalChannelCount = this.exporter.getChannelCount() * 11;
        int totalHandlerCount = this.exporter.getHandlerCount() * 5;
        return totalChannelCount + totalHandlerCount + 4;
    }
}

