/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.endpoint;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binding.InputBindingLifecycle;
import org.springframework.util.Assert;

@Endpoint(id="bindings")
public class BindingsEndpoint {
    private final List<InputBindingLifecycle> inputBindingLifecycles;
    private final ObjectMapper objectMapper;

    public BindingsEndpoint(List<InputBindingLifecycle> inputBindingLifecycles) {
        Assert.notEmpty(inputBindingLifecycles, (String)"'inputBindingLifecycles' must not be null or empty");
        this.inputBindingLifecycles = inputBindingLifecycles;
        this.objectMapper = new ObjectMapper();
    }

    @WriteOperation
    public void changeState(@Selector String name, State state) {
        Binding<?> binding = this.locateBinding(name);
        if (binding != null) {
            switch (state) {
                case STARTED: {
                    binding.start();
                    break;
                }
                case STOPPED: {
                    binding.stop();
                    break;
                }
                case PAUSED: {
                    binding.pause();
                    break;
                }
                case RESUMED: {
                    binding.resume();
                    break;
                }
            }
        }
    }

    @ReadOperation
    public List<?> queryStates() {
        return (List)this.objectMapper.convertValue(this.gatherInputBindings(), List.class);
    }

    @ReadOperation
    public Binding<?> queryState(@Selector String name) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        return this.locateBinding(name);
    }

    private List<Binding<?>> gatherInputBindings() {
        ArrayList inputBindings = new ArrayList();
        for (InputBindingLifecycle inputBindingLifecycle : this.inputBindingLifecycles) {
            Collection lifecycleInputBindings = (Collection)new DirectFieldAccessor((Object)inputBindingLifecycle).getPropertyValue("inputBindings");
            inputBindings.addAll(lifecycleInputBindings);
        }
        return inputBindings;
    }

    private Binding<?> locateBinding(String name) {
        return this.gatherInputBindings().stream().filter(binding -> name.equals(binding.getName())).findFirst().orElse(null);
    }

    private static enum State {
        STARTED,
        STOPPED,
        PAUSED,
        RESUMED;

    }
}

