/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.springframework.integration.codec.kryo.CompositeKryoRegistrar;
import org.springframework.integration.codec.kryo.KryoRegistrar;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;

@Deprecated
public class KryoMessageConverter
implements SmartMessageConverter {
    public static final String KRYO_MIME_TYPE = "application/x-java-object";
    protected final KryoPool pool;
    private final CompositeKryoRegistrar kryoRegistrar;
    private final boolean useReferences;
    private final List<MimeType> supportedMimeTypes;
    private ConcurrentMap<String, MimeType> mimeTypesCache = new ConcurrentHashMap<String, MimeType>();
    private ContentTypeResolver contentTypeResolver = new DefaultContentTypeResolver();

    public KryoMessageConverter(List<KryoRegistrar> kryoRegistrars, boolean useReferences) {
        this.useReferences = useReferences;
        this.kryoRegistrar = CollectionUtils.isEmpty(kryoRegistrars) ? null : new CompositeKryoRegistrar(kryoRegistrars);
        KryoFactory factory = () -> {
            Kryo kryo = new Kryo();
            this.configureKryoInstance(kryo);
            return kryo;
        };
        this.pool = new KryoPool.Builder(factory).softReferences().build();
        this.supportedMimeTypes = Collections.singletonList(MimeType.valueOf((String)KRYO_MIME_TYPE));
    }

    @Nullable
    public Object fromMessage(Message<?> message, Class<?> targetClass, @Nullable Object conversionHint) {
        if (!this.canConvertFrom(message, targetClass)) {
            return null;
        }
        if (!message.getPayload().getClass().isAssignableFrom(byte[].class)) {
            throw new MessageConversionException("This converter can only convert messages with byte[] payload");
        }
        byte[] payload = (byte[])message.getPayload();
        try {
            return this.deserialize(payload, targetClass);
        }
        catch (IOException e) {
            throw new MessageConversionException("Could not deserialize payload", (Throwable)e);
        }
    }

    @Nullable
    public Message<?> toMessage(Object payload, @Nullable MessageHeaders headers, @Nullable Object conversionHint) {
        MessageHeaderAccessor accessor;
        if (!this.canConvertTo(payload, headers)) {
            return null;
        }
        byte[] payloadToUse = this.serialize(payload);
        MimeType mimeType = this.getDefaultContentType(payload);
        if (headers != null && (accessor = MessageHeaderAccessor.getAccessor((MessageHeaders)headers, MessageHeaderAccessor.class)) != null && accessor.isMutable()) {
            if (mimeType != null) {
                accessor.setHeader("contentType", (Object)mimeType);
            }
            return MessageBuilder.createMessage((Object)payloadToUse, (MessageHeaders)accessor.getMessageHeaders());
        }
        MessageBuilder builder = MessageBuilder.withPayload((Object)payloadToUse);
        if (headers != null) {
            builder.copyHeaders((Map)headers);
        }
        if (mimeType != null) {
            builder.setHeader("contentType", (Object)mimeType);
        }
        return builder.build();
    }

    private boolean canConvertTo(Object payload, MessageHeaders headers) {
        return this.supports(payload.getClass()) && this.supportsMimeType(headers);
    }

    @Nullable
    protected MimeType getDefaultContentType(Object payload) {
        return this.mimeTypeFromObject(payload);
    }

    protected byte[] serialize(Object payload) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)baos);
        this.pool.run(kryo -> {
            kryo.writeObject(output, payload);
            return Void.TYPE;
        });
        output.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T deserialize(byte[] bytes, Class<T> type) throws IOException {
        Assert.notNull((Object)bytes, (String)"'bytes' cannot be null");
        try (Input input = new Input(bytes);){
            T t = this.deserialize((InputStream)input, type);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T deserialize(InputStream inputStream, Class<T> type) throws IOException {
        Assert.notNull((Object)inputStream, (String)"'inputStream' cannot be null");
        Assert.notNull(type, (String)"'type' cannot be null");
        Object result = null;
        try (Input input = inputStream instanceof Input ? (Input)inputStream : new Input(inputStream);){
            result = this.pool.run(kryo -> kryo.readObject(input, type));
        }
        return (T)result;
    }

    protected void configureKryoInstance(Kryo kryo) {
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        if (this.kryoRegistrar != null) {
            this.kryoRegistrar.registerTypes(kryo);
        }
        kryo.setReferences(this.useReferences);
    }

    protected MimeType mimeTypeFromObject(Object payload) {
        Assert.notNull((Object)payload, (String)"payload object cannot be null.");
        String className = payload.getClass().getName();
        MimeType mimeType = (MimeType)this.mimeTypesCache.get(className);
        if (mimeType == null) {
            String modifiedClassName = className;
            if (payload.getClass().isArray()) {
                if (modifiedClassName.endsWith(";")) {
                    modifiedClassName = modifiedClassName.substring(0, modifiedClassName.length() - 1);
                }
                modifiedClassName = "\"" + modifiedClassName + "\"";
            }
            mimeType = MimeType.valueOf((String)("application/x-java-object;type=" + modifiedClassName));
            this.mimeTypesCache.put(className, mimeType);
        }
        return mimeType;
    }

    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        return this.supports(targetClass) && this.supportsMimeType(message.getHeaders());
    }

    protected boolean supportsMimeType(@Nullable MessageHeaders headers) {
        if (this.getSupportedMimeTypes().isEmpty()) {
            return true;
        }
        MimeType mimeType = this.getMimeType(headers);
        if (mimeType == null) {
            return false;
        }
        for (MimeType current : this.getSupportedMimeTypes()) {
            if (!current.getType().equals(mimeType.getType()) || !current.getSubtype().equals(mimeType.getSubtype())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected MimeType getMimeType(@Nullable MessageHeaders headers) {
        return headers != null && this.contentTypeResolver != null ? this.contentTypeResolver.resolve(headers) : null;
    }

    private boolean supports(Class<?> targetClass) {
        return true;
    }

    @Nullable
    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        return this.fromMessage(message, targetClass, null);
    }

    @Nullable
    public Message<?> toMessage(Object payload, @Nullable MessageHeaders headers) {
        return this.toMessage(payload, headers, null);
    }

    public List<MimeType> getSupportedMimeTypes() {
        return this.supportedMimeTypes;
    }
}

