/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.test;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.cloud.stream.binder.test.AbstractDestination;
import org.springframework.integration.channel.AbstractSubscribableChannel;
import org.springframework.messaging.Message;
import org.springframework.util.StringUtils;

public class OutputDestination
extends AbstractDestination {
    private final Map<String, BlockingQueue<Message<byte[]>>> messageQueues = new LinkedHashMap<String, BlockingQueue<Message<byte[]>>>();

    public Message<byte[]> receive(long timeout, String bindingName) {
        try {
            return this.messageQueues.get(bindingName).poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public void clear() {
        this.messageQueues.values().forEach(v -> v.clear());
    }

    public boolean clear(String destinationName) {
        String queueName = destinationName;
        if (StringUtils.hasText((String)destinationName) && this.messageQueues.containsKey(queueName)) {
            this.messageQueues.get(queueName).clear();
            return true;
        }
        return false;
    }

    @Deprecated
    public Message<byte[]> receive(long timeout, int bindingIndex) {
        try {
            BlockingQueue<Message<byte[]>> destinationQueue = new ArrayList<BlockingQueue<Message<byte[]>>>(this.messageQueues.values()).get(bindingIndex);
            return destinationQueue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public Message<byte[]> receive() {
        return this.receive(0L, 0);
    }

    public Message<byte[]> receive(long timeout) {
        return this.receive(timeout, 0);
    }

    @Override
    void afterChannelIsSet(int channelIndex, String bindingName) {
        if (!this.messageQueues.containsKey(bindingName)) {
            LinkedTransferQueue messageQueue = new LinkedTransferQueue();
            this.messageQueues.put(bindingName, messageQueue);
            if (((AbstractSubscribableChannel)this.getChannelByName(bindingName)).getSubscriberCount() < 1) {
                this.getChannelByName(bindingName).subscribe(message -> this.messageQueues.get(bindingName).offer((Message<byte[]>)message));
            }
        }
    }
}

