/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.test;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binder.test.InputDestination;
import org.springframework.cloud.stream.binder.test.OutputDestination;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.messaging.SubscribableChannel;

public class TestChannelBinderProvisioner
implements ProvisioningProvider<ConsumerProperties, ProducerProperties> {
    private final Map<String, SubscribableChannel> provisionedDestinations = new HashMap<String, SubscribableChannel>();
    @Autowired
    private InputDestination source;
    @Autowired
    private OutputDestination target;

    public ProducerDestination provisionProducerDestination(String name, ProducerProperties properties) throws ProvisioningException {
        SubscribableChannel destination = this.provisionDestination(name, true);
        this.target.setChannel(destination);
        return new SpringIntegrationProducerDestination(name, destination);
    }

    public ConsumerDestination provisionConsumerDestination(String name, String group, ConsumerProperties properties) throws ProvisioningException {
        SubscribableChannel destination = this.provisionDestination(name, false);
        if (this.source != null) {
            this.source.setChannel(destination);
        }
        return new SpringIntegrationConsumerDestination(name, destination);
    }

    private SubscribableChannel provisionDestination(String name, boolean pubSub) {
        String destinationName = name + ".destination";
        SubscribableChannel destination = this.provisionedDestinations.get(destinationName);
        if (destination == null) {
            destination = pubSub ? new PublishSubscribeChannel() : new DirectChannel();
            ((AbstractMessageChannel)destination).setBeanName(destinationName);
            ((AbstractMessageChannel)destination).setComponentName(destinationName);
            this.provisionedDestinations.put(destinationName, destination);
        }
        return destination;
    }

    class SpringIntegrationProducerDestination
    implements ProducerDestination {
        private final String name;
        private final SubscribableChannel channel;

        SpringIntegrationProducerDestination(String name, SubscribableChannel channel) {
            this.name = name;
            this.channel = channel;
        }

        public String getNameForPartition(int partition) {
            return this.getName() + partition;
        }

        public SubscribableChannel getChannel() {
            return this.channel;
        }

        public String getName() {
            return this.name;
        }
    }

    class SpringIntegrationConsumerDestination
    implements ConsumerDestination {
        private final String name;
        private final SubscribableChannel channel;

        SpringIntegrationConsumerDestination(String name, SubscribableChannel channel) {
            this.name = name;
            this.channel = channel;
        }

        public SubscribableChannel getChannel() {
            return this.channel;
        }

        public String getName() {
            return this.name;
        }
    }
}

