/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.cloud.stream.messaging.DirectWithAttributesChannel;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;

public class SubscribableChannelBindingTargetFactory
extends AbstractBindingTargetFactory<SubscribableChannel> {
    private final MessageChannelConfigurer messageChannelConfigurer;
    @Autowired
    private GenericApplicationContext context;

    public SubscribableChannelBindingTargetFactory(MessageChannelConfigurer messageChannelConfigurer) {
        super(SubscribableChannel.class);
        this.messageChannelConfigurer = messageChannelConfigurer;
    }

    @Override
    public SubscribableChannel createInput(String name) {
        DirectWithAttributesChannel subscribableChannel = new DirectWithAttributesChannel();
        subscribableChannel.setComponentName(name);
        subscribableChannel.setAttribute("type", "input");
        this.messageChannelConfigurer.configureInputChannel((MessageChannel)subscribableChannel, name);
        if (this.context != null && !this.context.containsBean(name)) {
            this.context.registerBean(name, DirectWithAttributesChannel.class, () -> subscribableChannel, new BeanDefinitionCustomizer[0]);
        }
        return subscribableChannel;
    }

    @Override
    public SubscribableChannel createOutput(String name) {
        DirectWithAttributesChannel subscribableChannel = new DirectWithAttributesChannel();
        subscribableChannel.setComponentName(name);
        subscribableChannel.setAttribute("type", "output");
        this.messageChannelConfigurer.configureOutputChannel((MessageChannel)subscribableChannel, name);
        if (this.context != null && !this.context.containsBean(name)) {
            this.context.registerBean(name, DirectWithAttributesChannel.class, () -> subscribableChannel, new BeanDefinitionCustomizer[0]);
        }
        return subscribableChannel;
    }
}

