/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.BinderConfiguration;
import org.springframework.cloud.stream.binder.BinderCustomizer;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.BinderType;
import org.springframework.cloud.stream.binder.BinderTypeRegistry;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.PollableConsumerBinder;
import org.springframework.cloud.stream.binder.PollableMessageSource;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.config.ListenerContainerCustomizer;
import org.springframework.cloud.stream.config.SpelExpressionConverterConfiguration;
import org.springframework.cloud.stream.reflection.GenericsUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultBinderFactory
implements BinderFactory,
DisposableBean,
ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, BinderConfiguration> binderConfigurations;
    private final Map<String, Map.Entry<Binder<?, ?, ?>, ConfigurableApplicationContext>> binderInstanceCache = new HashMap();
    private final Map<String, String> defaultBinderForBindingTargetType = new HashMap<String, String>();
    private final BinderTypeRegistry binderTypeRegistry;
    private final BinderCustomizer binderCustomizer;
    private volatile ConfigurableApplicationContext context;
    private Collection<Listener> listeners;
    private volatile String defaultBinder;

    public DefaultBinderFactory(Map<String, BinderConfiguration> binderConfigurations, BinderTypeRegistry binderTypeRegistry, BinderCustomizer binderCustomizer) {
        this.binderConfigurations = new HashMap<String, BinderConfiguration>(binderConfigurations);
        this.binderTypeRegistry = binderTypeRegistry;
        this.binderCustomizer = binderCustomizer;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)applicationContext);
        this.context = (ConfigurableApplicationContext)applicationContext;
    }

    public void setDefaultBinder(String defaultBinder) {
        this.defaultBinder = defaultBinder;
    }

    public void setListeners(Collection<Listener> listeners) {
        this.listeners = listeners;
    }

    public void destroy() {
        this.binderInstanceCache.values().stream().map(Map.Entry::getValue).forEach(ConfigurableApplicationContext::close);
        this.defaultBinderForBindingTargetType.clear();
    }

    public synchronized <T> Binder<T, ?, ?> getBinder(String name, Class<? extends T> bindingTargetType) {
        Binder<? extends T, ConsumerProperties, ProducerProperties> binder;
        Map binders;
        String binderName = StringUtils.hasText((String)name) ? name : this.defaultBinder;
        Map map = binders = this.context == null ? Collections.emptyMap() : this.context.getBeansOfType(Binder.class);
        if (StringUtils.hasText((String)binderName) && binders.containsKey(binderName)) {
            binder = (Binder<? extends T, ConsumerProperties, ProducerProperties>)this.context.getBean(binderName);
        } else if (binders.size() == 1) {
            binder = (Binder)binders.values().iterator().next();
        } else {
            if (binders.size() > 1) {
                throw new IllegalStateException("Multiple binders are available, however neither default nor per-destination binder name is provided. Available binders are " + binders.keySet());
            }
            binder = this.doGetBinder(binderName, bindingTargetType);
        }
        if (this.binderCustomizer != null) {
            this.binderCustomizer.customize(binder, binderName);
        }
        return binder;
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T> Binder<T, ConsumerProperties, ProducerProperties> doGetBinder(String name, Class<? extends T> bindingTargetType) {
        String configurationName;
        block7: {
            block8: {
                block9: {
                    if (!MessageChannel.class.isAssignableFrom(bindingTargetType) && !PollableMessageSource.class.isAssignableFrom(bindingTargetType)) {
                        String bindingTargetTypeName = StringUtils.hasText((String)name) ? name : bindingTargetType.getSimpleName().toLowerCase();
                        return this.getBinderInstance(bindingTargetTypeName);
                    }
                    if (!StringUtils.isEmpty((Object)name)) break block8;
                    Assert.notEmpty(this.binderConfigurations, (String)"A default binder has been requested, but there is no binder available");
                    if (StringUtils.hasText((String)this.defaultBinder)) break block9;
                    HashSet<String> defaultCandidateConfigurations = new HashSet<String>();
                    for (Map.Entry<String, BinderConfiguration> binderConfigurationEntry : this.binderConfigurations.entrySet()) {
                        if (!binderConfigurationEntry.getValue().isDefaultCandidate()) continue;
                        defaultCandidateConfigurations.add(binderConfigurationEntry.getKey());
                    }
                    if (defaultCandidateConfigurations.size() == 1) {
                        configurationName = (String)defaultCandidateConfigurations.iterator().next();
                        this.defaultBinderForBindingTargetType.put(bindingTargetType.getName(), configurationName);
                        break block7;
                    } else {
                        ArrayList<String> candidatesForBindableType = new ArrayList<String>();
                        for (String defaultCandidateConfiguration : defaultCandidateConfigurations) {
                            Binder<T, ConsumerProperties, ProducerProperties> binderInstance = this.getBinderInstance(defaultCandidateConfiguration);
                            Class<T> binderType = GenericsUtils.getParameterType(binderInstance.getClass(), Binder.class, 0);
                            if (!binderType.isAssignableFrom(bindingTargetType)) continue;
                            candidatesForBindableType.add(defaultCandidateConfiguration);
                        }
                        if (candidatesForBindableType.size() == 1) {
                            configurationName = (String)candidatesForBindableType.iterator().next();
                            this.defaultBinderForBindingTargetType.put(bindingTargetType.getName(), configurationName);
                            break block7;
                        } else {
                            String countMsg = candidatesForBindableType.size() == 0 ? "are no binders" : "is more than one binder";
                            throw new IllegalStateException("A default binder has been requested, but there " + countMsg + " available for '" + bindingTargetType.getName() + "' : " + StringUtils.collectionToCommaDelimitedString(candidatesForBindableType) + ", and no default binder has been set.");
                        }
                    }
                }
                configurationName = this.defaultBinder;
                break block7;
            }
            configurationName = name;
        }
        Binder<T, ConsumerProperties, ProducerProperties> binderInstance = this.getBinderInstance(configurationName);
        Assert.state((boolean)this.verifyBinderTypeMatchesTarget(binderInstance, bindingTargetType), (String)("The binder '" + configurationName + "' cannot bind a " + bindingTargetType.getName()));
        return binderInstance;
    }

    private <T> boolean verifyBinderTypeMatchesTarget(Binder<T, ?, ?> binderInstance, Class<? extends T> bindingTargetType) {
        return binderInstance instanceof PollableConsumerBinder && GenericsUtils.checkCompatiblePollableBinder(binderInstance, bindingTargetType) || GenericsUtils.getParameterType(binderInstance.getClass(), Binder.class, 0).isAssignableFrom(bindingTargetType);
    }

    private <T> Binder<T, ConsumerProperties, ProducerProperties> getBinderInstance(String configurationName) {
        if (!this.binderInstanceCache.containsKey(configurationName)) {
            FunctionCatalog functionCatalog;
            this.logger.debug((Object)("Creating binder: " + configurationName));
            BinderConfiguration binderConfiguration = this.binderConfigurations.get(configurationName);
            Assert.state((binderConfiguration != null ? 1 : 0) != 0, (String)("Unknown binder configuration: " + configurationName));
            BinderType binderType = this.binderTypeRegistry.get(binderConfiguration.getBinderType());
            Assert.notNull((Object)binderType, (String)("Binder type " + binderConfiguration.getBinderType() + " is not defined"));
            HashMap<String, Object> binderProperties = new HashMap<String, Object>();
            this.flatten(null, binderConfiguration.getProperties(), binderProperties);
            ConfigurableApplicationContext binderProducingContext = this.initializeBinderContextSimple(configurationName, binderProperties, binderType, binderConfiguration);
            Map messageConverters = binderProducingContext.getBeansOfType(MessageConverter.class);
            if (!CollectionUtils.isEmpty((Map)messageConverters) && !ObjectUtils.isEmpty((Object)this.context.getBeansOfType(FunctionCatalog.class)) && (functionCatalog = (FunctionCatalog)this.context.getBean(FunctionCatalog.class)) instanceof SimpleFunctionRegistry) {
                ((SimpleFunctionRegistry)functionCatalog).addMessageConverters(messageConverters.values());
            }
            Binder binder = (Binder)binderProducingContext.getBean(Binder.class);
            if (this.context != null && binder instanceof ApplicationContextAware) {
                ((ApplicationContextAware)binder).setApplicationContext((ApplicationContext)this.context);
            }
            if (!CollectionUtils.isEmpty(this.listeners)) {
                for (Listener binderFactoryListener : this.listeners) {
                    binderFactoryListener.afterBinderContextInitialized(configurationName, binderProducingContext);
                }
            }
            this.logger.debug((Object)("Caching the binder: " + configurationName));
            this.binderInstanceCache.put(configurationName, new AbstractMap.SimpleImmutableEntry<Binder, ConfigurableApplicationContext>(binder, binderProducingContext));
        }
        this.logger.debug((Object)("Retrieving cached binder: " + configurationName));
        return this.binderInstanceCache.get(configurationName).getKey();
    }

    private ConfigurableApplicationContext initializeBinderContextSimple(String configurationName, Map<String, Object> binderProperties, BinderType binderType, BinderConfiguration binderConfiguration) {
        ConfigurableEnvironment environment;
        String sources;
        AnnotationConfigApplicationContext binderProducingContext = new AnnotationConfigApplicationContext();
        if (this.context != null) {
            binderProducingContext.getBeanFactory().setConversionService(this.context.getBeanFactory().getConversionService());
        }
        ArrayList sourceClasses = new ArrayList();
        sourceClasses.addAll(Arrays.asList(binderType.getConfigurationClasses()));
        sourceClasses.addAll(Collections.singletonList(SpelExpressionConverterConfiguration.class));
        if (binderProperties.containsKey("spring.main.sources") && StringUtils.hasText((String)(sources = (String)binderProperties.get("spring.main.sources")))) {
            Stream.of(sources.split(",")).forEach(source -> {
                try {
                    sourceClasses.add(Thread.currentThread().getContextClassLoader().loadClass(source.trim()));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to load class " + source, e);
                }
            });
        }
        binderProducingContext.register(sourceClasses.toArray(new Class[0]));
        MapPropertySource binderPropertySource = new MapPropertySource(configurationName, binderProperties);
        binderProducingContext.getEnvironment().getPropertySources().addFirst((PropertySource)binderPropertySource);
        binderProducingContext.setDisplayName(configurationName + "_context");
        boolean useApplicationContextAsParent = binderProperties.isEmpty() && this.context != null;
        ConfigurableEnvironment configurableEnvironment = environment = this.context != null ? this.context.getEnvironment() : null;
        if (useApplicationContextAsParent) {
            binderProducingContext.setParent((ApplicationContext)this.context);
        } else if (this.context != null) {
            this.propagateSharedBeans((GenericApplicationContext)binderProducingContext);
            Map customizers = this.context.getBeansOfType(ListenerContainerCustomizer.class);
            binderProducingContext.addApplicationListener((ApplicationListener)new ApplicationListener<ApplicationEvent>(){

                public void onApplicationEvent(ApplicationEvent event) {
                    if (DefaultBinderFactory.this.context != null) {
                        try {
                            DefaultBinderFactory.this.context.publishEvent(event);
                        }
                        catch (Exception e) {
                            DefaultBinderFactory.this.logger.warn((Object)("Failed to publish " + event), (Throwable)e);
                        }
                    }
                }
            });
            if (environment != null && !useApplicationContextAsParent) {
                InitializerWithOuterContext initializer = new InitializerWithOuterContext((ApplicationContext)this.context);
                initializer.initialize((ConfigurableApplicationContext)binderProducingContext);
            }
            if (environment != null && (useApplicationContextAsParent || binderConfiguration.isInheritEnvironment())) {
                binderProducingContext.getEnvironment().merge(environment);
                binderProducingContext.getEnvironment().getPropertySources().remove("configurationProperties");
                binderProducingContext.getEnvironment().getPropertySources().addFirst((PropertySource)new MapPropertySource("defaultBinderFactoryProperties", Collections.singletonMap("spring.main.web-application-type", "NONE")));
            }
        }
        binderProducingContext.refresh();
        return binderProducingContext;
    }

    private void propagateSharedBeans(GenericApplicationContext binderProducingContext) {
        GenericConversionService binderProducingConversionService = (GenericConversionService)binderProducingContext.getBeanFactory().getConversionService();
        try {
            Enumeration<URL> resources = ClassUtils.getDefaultClassLoader().getResources("META-INF/shared.beans");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                UrlResource resource = new UrlResource(url);
                Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
                Set<Object> classNames = properties.keySet();
                for (Object className : classNames) {
                    Class<Object> beanType = this.loadClass(((String)className).trim());
                    if (beanType == null) continue;
                    Map beansOfType = this.context.getBeansOfType(beanType);
                    beansOfType.entrySet().stream().forEach(entry -> {
                        Object bean = entry.getValue();
                        if (bean instanceof Converter) {
                            binderProducingConversionService.addConverter((Converter)bean);
                        } else {
                            binderProducingContext.registerBean((String)entry.getKey() + "_child", beanType, () -> entry.getValue(), new BeanDefinitionCustomizer[0]);
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"Failed to propagate child beans. This may cause issues in your application", (Throwable)e);
        }
    }

    private Class<Object> loadClass(String className) {
        try {
            return ClassUtils.getDefaultClassLoader().loadClass(className.trim());
        }
        catch (Throwable e) {
            this.logger.debug((Object)("Attempt to load " + className + " failed."), e);
            return null;
        }
    }

    private void flatten(String propertyName, Object value, Map<String, Object> flattenedProperties) {
        if (value instanceof Map) {
            ((Map)value).forEach((k, v) -> this.flatten((propertyName != null ? propertyName + "." : "") + k, v, flattenedProperties));
        } else {
            flattenedProperties.put(propertyName, value.toString());
        }
    }

    private static class InitializerWithOuterContext
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private final ApplicationContext context;

        InitializerWithOuterContext(ApplicationContext context) {
            this.context = context;
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            applicationContext.getBeanFactory().registerSingleton("outerContext", (Object)this.context);
        }
    }

    public static interface Listener {
        public void afterBinderContextInitialized(String var1, ConfigurableApplicationContext var2);
    }
}

